/*
 * Decompiled with CFR 0.152.
 */
package I2CSettings;

import I2CSettings.I2CSettings;
import com.microchip.core.util.HexOnlyValidator;
import com.microchip.core.util.HexValidator;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import toplevel.JavaFXTextFieldChangeListener;
import unified.bootloader.model.UBootModel;

public class I2CSettingsFXMLController
implements Initializable {
    I2CSettings application;
    @FXML
    private Button buttonRefresh;
    @FXML
    private ComboBox<String> comboDevice;
    @FXML
    private TextField fieldAddress;
    @FXML
    private TextField fieldBitRate;
    private final String stringNone = "None";
    Map<TextField, JavaFXTextFieldChangeListener<UBootModel>> changeListener = new HashMap<TextField, JavaFXTextFieldChangeListener<UBootModel>>();
    public String lowerLevelDriver = null;

    public I2CSettingsFXMLController(I2CSettings application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        final HexValidator validatorHex22 = new HexValidator();
        validatorHex22.setValidCount(22);
        final HexOnlyValidator validatorHexOnly1 = new HexOnlyValidator();
        validatorHexOnly1.setMaxBitCount(8);
        validatorHexOnly1.setMinBitCount(0);
        Image imageRefresh = new Image(this.getClass().getResourceAsStream("refreshIcon.png"));
        ImageView imageButtonRefresh = new ImageView();
        imageButtonRefresh.setImage(imageRefresh);
        imageButtonRefresh.setFitWidth(20.0);
        imageButtonRefresh.setPreserveRatio(true);
        imageButtonRefresh.setSmooth(true);
        imageButtonRefresh.setCache(true);
        this.buttonRefresh.setGraphic((Node)imageButtonRefresh);
        JavaFXTextFieldChangeListener listener = new JavaFXTextFieldChangeListener<UBootModel>(this.fieldBitRate, this.application.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = validatorHex22.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).i2cPojo.setDeviceBitRate(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        listener.setValidator(validatorHex22);
        this.changeListener.put(this.fieldBitRate, listener);
        this.fieldBitRate.textProperty().addListener((ChangeListener)listener);
        if (!this.application.application.getModel().i2cPojo.getDeviceBitRate().equals("")) {
            this.fieldBitRate.setText(this.application.application.getModel().i2cPojo.getDeviceBitRate());
        }
        listener = new JavaFXTextFieldChangeListener<UBootModel>(this.fieldAddress, this.application.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = validatorHexOnly1.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).i2cPojo.setDeviceAddress(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        listener.setValidator(validatorHexOnly1);
        this.changeListener.put(this.fieldAddress, listener);
        this.fieldAddress.textProperty().addListener((ChangeListener)listener);
        if (!this.application.application.getModel().i2cPojo.getDeviceAddress().equals("")) {
            this.fieldAddress.setText(this.application.application.getModel().i2cPojo.getDeviceAddress());
        }
        this.refreshCOMList();
    }

    @FXML
    void actionApplySettings(ActionEvent event) {
        this.application.application.getModel().i2cPojo.setDeviceSelected((String)this.comboDevice.getValue());
        this.application.application.getModel().i2cPojo.setDeviceAddress(this.fieldAddress.getText());
        this.application.application.getModel().i2cPojo.setDeviceBitRate(this.fieldBitRate.getText());
        this.application.application.getModel().i2cPojo.setConfigured(true);
        this.application.dialogStage.close();
    }

    @FXML
    void actionRefreshComList() {
        this.buttonRefresh.setDisable(true);
        this.refreshCOMList();
        this.buttonRefresh.setDisable(false);
    }

    public void refreshCOMList() {
        this.comboDevice.setItems(this.application.application.getModel().i2cPojo.getDeviceList());
    }
}

