/*
 * Decompiled with CFR 0.152.
 */
package udpSettings32bit;

import com.microchip.core.util.HexValidator;
import com.microchip.core.util.IPValidator;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import toplevel.JavaFXTextFieldChangeListener;
import udpSettings32bit.UdpSettings32bit;
import unified.bootloader.model32bit.UBootModel32bit;

public class UdpSettingsFXMLController32bit
implements Initializable {
    UdpSettings32bit application;
    @FXML
    private Label udpIpAddress;
    @FXML
    private Label udpIpPort;
    @FXML
    private TextField textIpAddress;
    @FXML
    private TextField textIpPort;
    @FXML
    private Button buttonApplySettings;
    final String mcp2221DefaultIp = "192.168.1.11";
    final String mcp2221DefaultPort = "6234";
    Map<TextField, JavaFXTextFieldChangeListener<UBootModel32bit>> changeListener = new HashMap<TextField, JavaFXTextFieldChangeListener<UBootModel32bit>>();

    public UdpSettingsFXMLController32bit(UdpSettings32bit application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        IPValidator ipValidator = new IPValidator();
        HexValidator validatorHex16 = new HexValidator();
        validatorHex16.setValidCount(16);
        if (!this.application.application.getModel().udpPojo32Bit.getIpAddress().equals("")) {
            this.textIpAddress.setText(this.application.application.getModel().udpPojo32Bit.getIpAddress());
        }
        JavaFXTextFieldChangeListener listener = new JavaFXTextFieldChangeListener<UBootModel32bit>(this.textIpAddress, this.application.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel32bit)this.device).updateValueFlag) {
                            ((UBootModel32bit)this.device).udpPojo32Bit.setIpAddress(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        listener.setValidator(ipValidator);
        this.changeListener.put(this.textIpAddress, listener);
        this.textIpAddress.textProperty().addListener((ChangeListener)listener);
        this.textIpAddress.setText("192.168.1.11");
        if (!this.application.application.getModel().udpPojo32Bit.getIpPort().equals("")) {
            this.textIpPort.setText(this.application.application.getModel().udpPojo32Bit.getIpPort());
        }
        listener = new JavaFXTextFieldChangeListener<UBootModel32bit>(this.textIpPort, this.application.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel32bit)this.device).updateValueFlag) {
                            ((UBootModel32bit)this.device).udpPojo32Bit.setIpPort(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        listener.setValidator(validatorHex16);
        this.changeListener.put(this.textIpPort, listener);
        this.textIpPort.textProperty().addListener((ChangeListener)listener);
        this.textIpPort.setText("6234");
    }

    @FXML
    void actionApplySettings(ActionEvent event) {
        this.application.application.getModel().udpPojo32Bit.setIpAddress(this.textIpAddress.getText());
        this.application.application.getModel().udpPojo32Bit.setIpPort(this.textIpPort.getText());
        this.application.application.getModel().udpPojo32Bit.setConfigured(true);
        this.application.dialogStage.close();
    }

    @FXML
    void actionConfigureIP(ActionEvent event) {
        IPValidator ipValidator = new IPValidator();
        JavaFXTextFieldChangeListener<UBootModel32bit> listener = new JavaFXTextFieldChangeListener<UBootModel32bit>(this.textIpAddress, this.application.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel32bit)this.device).updateValueFlag) {
                            ((UBootModel32bit)this.device).udpPojo32Bit.setIpAddress(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        listener.setValidator(ipValidator);
        this.changeListener.put(this.textIpAddress, listener);
        this.textIpAddress.textProperty().addListener((ChangeListener)listener);
    }
}

