/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.Optional;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.DetailedException;
import unified.bootloader16bit.FnNormalize;
import unified.bootloader16bit.FnToStringVerbose;

public class CommandException
extends DetailedException {
    private final String details;
    public static final String MESSAGE = "Command Exception.";

    public CommandException(String message, String details) {
        super(message, details);
        this.details = details;
    }

    public CommandException(Optional<String> message, Optional<String> details, Command request, Command response) {
        this(message.orElse(MESSAGE), CommandException.createDetails(details, request, response));
    }

    private static String createResponseDetails(Command response) {
        if (response == null) {
            return "Response: No response received.";
        }
        return "Response: " + response.accept(new FnNormalize()).accept(new FnToStringVerbose());
    }

    private static String createRequestDetails(Command request) {
        if (request == null) {
            return "Command: No command provided.";
        }
        return "Command: " + request.accept(new FnNormalize()).accept(new FnToStringVerbose());
    }

    private static String createDetails(Optional<String> startingDetails, Command request, Command response) {
        StringBuilder builder = new StringBuilder();
        startingDetails.ifPresent(details -> builder.append((String)details).append(System.lineSeparator()));
        builder.append(CommandException.createRequestDetails(request));
        builder.append(" ");
        builder.append(CommandException.createResponseDetails(response));
        return builder.toString();
    }

    @Override
    public String getDetails() {
        return this.details;
    }
}

