/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import unified.bootloader16bit.Alert;
import unified.bootloader16bit.DetailedException;
import unified.bootloader16bit.EventHandler;
import unified.bootloader16bit.ModelProxy;

class EventHandlerImpl
implements EventHandler {
    private final Console16bit console;
    private final Consumer<Double> progress;
    private final Consumer<String> status;
    private final Consumer<String> alert;
    private static final String TATTLE = "A software error has occurred.";

    EventHandlerImpl(ModelProxy modelProxy, Console16bit console) {
        this(modelProxy::setResultStatus, modelProxy::setProgress, Alert::show, console);
    }

    EventHandlerImpl(Consumer<String> status, Consumer<Double> progress, Consumer<String> alert, Console16bit console) {
        this.status = status;
        this.progress = progress;
        this.console = console;
        this.alert = alert;
    }

    @Override
    public void resetSuccessful() {
        String msg = "Device reset successful.";
        this.status.accept(msg);
        this.console.addConsoleText(msg);
    }

    @Override
    public void setProgress(double percent) {
        this.progress.accept(percent);
    }

    @Override
    public void resetRequested() {
        String msg = "Requesting to reset the device...";
        this.status.accept(msg);
        this.console.addConsoleText(msg);
    }

    @Override
    public void serialConfigException(IOException e) {
        String msg = "Failed to show Serial Configuration!";
        this.status.accept(msg);
        this.console.addConsoleText(Level.SEVERE, msg + System.lineSeparator() + this.getStackTrace(e));
        this.alert.accept(msg);
    }

    @Override
    public void programmingFinished() {
        this.updateStatus("Programming Finished.");
    }

    @Override
    public void programmingStarted() {
        this.updateStatus("Programming...", "Programming Started.");
    }

    @Override
    public void eraseRequested() {
        this.updateStatus("Erasing...", "Requesting to erase the application.");
    }

    @Override
    public void eraseFinished() {
        this.updateStatus("Finished erasing.");
    }

    @Override
    public void finishedEverything() {
        this.updateStatus("Finished executing requested operations.");
    }

    @Override
    public void readBackVerificationRequested() {
        this.updateStatus("Verifying via read back...", "Verifying the contents of the application space by reading back memory contents...");
    }

    @Override
    public void readBackVerificationPassed() {
        this.updateStatus("Read back verification passed.");
    }

    @Override
    public void interruptException(InterruptedException e) {
        this.status.accept("");
        this.progress.accept(0.0);
        this.alert.accept(e.getMessage());
    }

    @Override
    public void executionException(ExecutionException e) {
        this.status.accept("");
        this.progress.accept(0.0);
        Throwable error = e.getCause();
        if (error instanceof BufferUnderflowException) {
            String contentText = "Unable to establish communication with device.  Common issues are incorrect configuration UART/Communication port settings on the PC or incorrect UART/Communication port settings on the device.  Please check and retry.";
            this.alert.accept(contentText);
            this.console.addConsoleText(Level.SEVERE, contentText);
        } else if (error instanceof Exception) {
            this.unknownError(e);
        } else {
            this.showError("An unknown execution exception has occurred.", Optional.empty());
        }
    }

    private void showError(String shortDescription, Optional<String> details) {
        this.showError(shortDescription, details, true);
    }

    private void showError(String shortDescription, Optional<String> details, boolean needsAlert) {
        ArrayList<String> consoleMessages = new ArrayList<String>();
        this.progress.accept(0.0);
        consoleMessages.add(shortDescription);
        details.ifPresent(consoleMessages::add);
        this.console.addConsoleText(Level.SEVERE, consoleMessages);
        this.status.accept(shortDescription);
        if (needsAlert) {
            this.alert.accept(shortDescription + "\n\nPlease see the 'Tools > Console' window for details.");
        }
    }

    private void updateStatus(String message) {
        this.updateStatus(message, message);
    }

    private void updateStatus(String message, String details) {
        this.status.accept(message);
        this.console.addConsoleText(details);
    }

    @Override
    public void linkError(UnsatisfiedLinkError e) {
        this.showError("Unable to load required driver.", Optional.of(e.getMessage()));
    }

    @Override
    public void noClassDefError(NoClassDefFoundError e) {
        this.showError("Unable to load required driver.", Optional.of(e.getMessage()));
    }

    private void unknownError(Exception e) {
        this.showError(TATTLE, Optional.of("A software error has occurred.: " + e.getClass() + " - " + e.getMessage()));
        this.console.addConsoleText(Level.FINEST, this.getStackTrace(e));
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    @Override
    public void selfVerificationRequested() {
        this.updateStatus("Requesting device to self verify...", "Requesting device to self verify the contents of the application space...");
    }

    @Override
    public void selfVerificationPassed() {
        this.updateStatus("Self verification passed.");
    }

    @Override
    public void exception(Exception e) {
        if (e instanceof DetailedException) {
            DetailedException detailed = (DetailedException)e;
            this.showError(detailed.getSummary(), Optional.of(detailed.getDetails()), detailed.getSeverity() == DetailedException.Severity.HIGH);
        } else {
            this.unknownError(e);
        }
    }
}

