/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import unified.bootloader16bit.BadResponseException;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandFactory;
import unified.bootloader16bit.CommandFactoryImpl;
import unified.bootloader16bit.CommandStatusFactory;
import unified.bootloader16bit.CommandStatusFactoryImpl;
import unified.bootloader16bit.FnAddressAccessor;
import unified.bootloader16bit.FnDataAccessor;
import unified.bootloader16bit.FnDataLengthAccessor;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolInUseException;
import unified.bootloader16bit.TimeoutException;

public class ProtocolMock
implements Protocol {
    private boolean isOpen = false;
    private final CommandFactory commandFactory;
    private final CommandStatusFactory commandStatusFactory;
    private final ByteBuffer response = ByteBuffer.allocate(1024);
    private final ByteBuffer flashBuffer = ByteBuffer.allocate(1024);
    private final Map<Integer, Integer> flash;
    private final Map<Integer, Integer> flashWriteCount;
    private final Map<Integer, Integer> flashReadCount;
    private int minByteCount;

    public ProtocolMock() {
        this.commandFactory = new CommandFactoryImpl();
        this.commandStatusFactory = new CommandStatusFactoryImpl();
        this.response.order(ByteOrder.LITTLE_ENDIAN);
        this.flashBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.flash = new HashMap<Integer, Integer>();
        this.flashWriteCount = new HashMap<Integer, Integer>();
        this.flashReadCount = new HashMap<Integer, Integer>();
        this.minByteCount = 4;
    }

    public void setMinByteCount(int count) {
        this.minByteCount = count;
    }

    @Override
    public void config() {
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean ready() {
        return this.isOpen;
    }

    @Override
    public void open() throws ProtocolInUseException {
        if (this.isOpen) {
            throw new ProtocolInUseException("Protocol already open");
        }
        this.isOpen = true;
    }

    @Override
    public ByteBuffer transceive(ByteBuffer commandData, Integer responseLength, Integer timeoutMilliseconds) throws IOException, TimeoutException, BadResponseException {
        commandData.flip();
        this.write(commandData);
        ByteBuffer commandResponse = this.response.duplicate();
        commandResponse.flip();
        this.response.clear();
        return commandResponse;
    }

    @Override
    public String getHardwareMisconfigurationMessage() {
        return "";
    }

    public Map<Integer, Integer> getWriteCounts() {
        return this.flashWriteCount;
    }

    public Map<Integer, Integer> getReadCounts() {
        return this.flashReadCount;
    }

    public Map<Integer, Integer> getMirrorImage() {
        return this.flash;
    }

    public void writeFlash(int address, int data) {
        this.flash.put(address, data);
    }

    public int read(ByteBuffer dst) {
        this.response.flip();
        int remaining = this.response.remaining();
        while (this.response.hasRemaining()) {
            dst.put(this.response.get());
        }
        this.response.clear();
        return remaining;
    }

    public int write(ByteBuffer src) {
        int remaining = src.remaining();
        src.mark();
        byte b = src.get();
        src.reset();
        if (b == this.commandFactory.getVersionCommandId()) {
            this.handleGetVersion();
        } else if (b == this.commandFactory.getWriteFlashCommandId()) {
            this.handleWriteFlash(src);
        } else if (b == this.commandFactory.getReadFlashCommandId()) {
            this.handleReadFlash(src);
        } else if (b == this.commandFactory.getEraseFlashCommandId()) {
            this.handleErase(src);
        } else if (b == this.commandFactory.getResetDeviceCommandId()) {
            this.handleReset(src);
        } else if (b == this.commandFactory.getSelfVerifyCommandId()) {
            this.handleSelfVerify(src);
        } else {
            this.handleUnsupportedCommand(src);
        }
        return remaining;
    }

    private void successfulCommand(ByteBuffer src) {
        this.response.clear();
        while (src.hasRemaining()) {
            this.response.put(src.get());
        }
        this.response.put(this.commandStatusFactory.getCommandSuccessId());
    }

    private void handleSelfVerify(ByteBuffer src) {
        this.successfulCommand(src);
    }

    private void handleUnsupportedCommand(ByteBuffer src) {
        this.response.clear();
        while (src.hasRemaining()) {
            this.response.put(src.get());
        }
        this.response.put(this.commandStatusFactory.getCommandUnsupportedId());
    }

    private void handleReset(ByteBuffer src) {
        this.handleErase(src);
    }

    private void handleErase(ByteBuffer src) {
        this.flash.clear();
        this.successfulCommand(src);
    }

    private void handleReadFlash(ByteBuffer src) {
        this.successfulCommand(src);
        src.reset();
        Command request = this.getReadCommandRequest(src);
        Integer address = request.accept(new FnAddressAccessor()).intValue();
        Integer length = request.accept(new FnDataLengthAccessor());
        while (length > 0) {
            this.response.putInt(this.readFlash(address));
            address = address + 2;
            length = length - 4;
        }
    }

    private void handleWriteFlash(ByteBuffer src) {
        src.reset();
        Command writeRequest = this.getWriteRequest(src);
        src.reset();
        this.fillResponse(src);
        this.fillFlashBuffer(writeRequest);
    }

    private Command getWriteRequest(ByteBuffer src) {
        Command writeRequest = this.getCommonCommandRequest(src);
        while (src.hasRemaining()) {
            int anInt = src.getInt();
            writeRequest = writeRequest.addWord(anInt);
        }
        return writeRequest;
    }

    private void fillResponse(ByteBuffer src) {
        int payloadSize = src.remaining() - 11;
        this.response.clear();
        for (int i = 0; i < 11; ++i) {
            this.response.put(src.get());
        }
        if (payloadSize % this.minByteCount == 0) {
            this.response.put(this.commandStatusFactory.getCommandSuccessId());
        } else {
            this.response.put(this.commandStatusFactory.getAddressErrorId());
        }
    }

    private void fillFlashBuffer(Command writeRequest) {
        Integer address = writeRequest.accept(new FnAddressAccessor()).intValue();
        this.flashBuffer.clear();
        writeRequest.accept(new FnDataAccessor()).accept(this.flashBuffer);
        this.flashBuffer.flip();
        while (this.flashBuffer.hasRemaining()) {
            this.flash.put(address, this.flashBuffer.getInt());
            Integer c = this.flashWriteCount.getOrDefault(address, 0) + 1;
            this.flashWriteCount.put(address, c);
            address = address + 2;
        }
    }

    private void handleGetVersion() {
        this.response.clear();
        this.response.put(this.commandFactory.getVersionCommandId());
        this.response.putShort((short)0);
        this.response.putInt(0);
        this.response.putInt(0);
        this.response.putShort((short)6);
        this.response.putShort((short)256);
        this.response.putShort((short)0);
        this.response.putShort((short)-24228);
        this.response.putShort((short)0);
        this.response.putShort((short)4096);
        this.response.putShort((byte)this.minByteCount);
        this.response.putInt(0);
        this.response.putInt(0);
        this.response.putInt(0);
    }

    public int readFlash(int address) {
        Integer count = this.flashReadCount.getOrDefault(address, 0);
        this.flashReadCount.put(address, count + 1);
        return this.flash.getOrDefault(address, 0);
    }

    private Command getReadCommandRequest(ByteBuffer bb) {
        return new PropCommandBase().setCommand(this.getUnsignedByte(bb)).setLength(this.getUnsignedShort(bb)).setUnlock(this.getUnsignedInt(bb)).setAddress(this.getUnsignedInt(bb));
    }

    private Command getCommonCommandRequest(ByteBuffer bb) {
        return new PropCommandBase().setCommand(this.getUnsignedByte(bb)).setLength(this.getUnsignedShort(bb)).setUnlock(this.getUnsignedInt(bb)).setAddress(this.getUnsignedInt(bb));
    }

    private int getUnsignedInt(ByteBuffer bb) {
        return (int)((long)bb.getInt() & 0xFFFFFFFFL);
    }

    private short getUnsignedShort(ByteBuffer bb) {
        return (short)(bb.getShort() & 0xFFFF);
    }

    private byte getUnsignedByte(ByteBuffer bb) {
        return (byte)(bb.get() & 0xFF);
    }
}

