/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.hexfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import unified.bootloader16bit.hexfile.HexParser;
import unified.bootloader16bit.hexfile.HexRecord;
import unified.bootloader16bit.hexfile.InvalidRecordException;

public class HexParserImpl
implements HexParser {
    private final Map<Integer, Integer> memory = new HashMap<Integer, Integer>();
    private int extendedLinearAddress;
    private boolean endOfFile = false;
    private static final int BYTES_PER_PC_UNIT = 2;
    private static final int BLANK_INSTRUCTION_UPPER_WORD = 255;

    public Map<Integer, Integer> getMemory() {
        return this.memory;
    }

    public HexParserImpl() {
        this.reset();
    }

    private void reset() {
        this.memory.clear();
        this.extendedLinearAddress = 0;
        this.endOfFile = false;
    }

    protected void parseRecord(String recordString) throws InvalidRecordException {
        if (this.endOfFile) {
            return;
        }
        HexRecord hexRecord = HexRecord.create(recordString);
        switch (hexRecord.getType()) {
            case DATA: {
                this.processDataRecord(hexRecord);
                break;
            }
            case EXTENDED_LINEAR_ADDRESS: {
                this.processExtendedLinearAddressRecord(hexRecord);
                break;
            }
            case END_OF_FILE: {
                this.endOfFile = true;
                break;
            }
        }
    }

    private void processDataRecord(HexRecord hexRecord) {
        ByteBuffer data = ByteBuffer.wrap(hexRecord.getData());
        data.order(ByteOrder.LITTLE_ENDIAN);
        int pcAddress = (hexRecord.getAddress() + this.extendedLinearAddress * 65536) / 2;
        while (data.hasRemaining()) {
            int dataChunk = data.remaining() >= 4 ? data.getInt() : 0xFF0000 + this.removeSignExtension(data.getShort());
            this.memory.put(pcAddress, dataChunk);
            pcAddress += 2;
        }
    }

    private void processExtendedLinearAddressRecord(HexRecord hexRecord) {
        ByteBuffer data = ByteBuffer.wrap(hexRecord.getData());
        this.extendedLinearAddress = data.getShort();
    }

    @Override
    public Map<Integer, Integer> parse(Path file) throws IOException, InvalidRecordException {
        this.reset();
        try (Stream<String> fileLines = Files.lines(file);){
            Iterator iterator = fileLines.iterator();
            while (iterator.hasNext()) {
                this.parseRecord((String)iterator.next());
            }
            Map<Integer, Integer> map = this.getMemory();
            return map;
        }
    }

    private int removeSignExtension(short data) {
        return data & 0xFFFF;
    }
}

