/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class I2CAddressFormat {
    private I2CAddressFormat() {
    }

    public static Optional<Integer> getAddress(String address) {
        String addressString = "(0x)?(?<value>[0-9a-fA-F]{1,2})";
        Pattern compile = Pattern.compile(addressString);
        Matcher matcher = compile.matcher(address.trim());
        if (matcher.matches()) {
            Integer value = Integer.parseInt(matcher.group("value"), 16);
            return I2CAddressFormat.isValidAddress(value) ? Optional.of(value) : Optional.empty();
        }
        return Optional.empty();
    }

    static boolean isValidAddress(Integer address) {
        return address >= 8 && address <= 119;
    }

    static boolean isNumber(String address) {
        return address.trim().matches("(0x)?[0-9a-fA-F]+");
    }
}

