/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.nio.ByteBuffer;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.InvalidPduException;
import unified.bootloader16bit.phy.lin.Pdu;

public class PduFirstFrame
implements Pdu {
    public static final int DATA_LENGTH_IN_FRAME = 4;
    private static final int MIN_MESSAGE_LEN_FIRST_FRAME = 7;
    private static final int DATA_START_INDEX = 4;
    private static final int SERVICE_ID_INDEX = 3;
    private final int totalMessageLength;
    private final byte nodeAddress;
    private final byte serviceId;
    private final byte[] data;

    private PduFirstFrame(byte nodeAddress, byte serviceId, byte[] data, int totalMessageLength) {
        this.totalMessageLength = totalMessageLength;
        this.nodeAddress = nodeAddress;
        this.serviceId = serviceId;
        this.data = data;
    }

    public static PduFirstFrame create(byte nodeAddress, byte serviceId, byte[] data) throws InvalidPduException {
        PduFirstFrame.validateDataLength(data.length);
        return new PduFirstFrame(nodeAddress, serviceId, data, data.length + 1);
    }

    public static PduFirstFrame create(byte[] frame) throws InvalidPduException {
        if (frame.length != 8) {
            throw new InvalidPduException("Invalid frame length: " + frame.length);
        }
        if (!Pdu.Type.get(frame).equals((Object)Pdu.Type.FIRST_FRAME)) {
            throw new InvalidPduException("Invalid frame type: " + (Object)((Object)Pdu.Type.get(frame)));
        }
        int length = PduFirstFrame.getLength(frame[1], frame[2]);
        byte[] data = new byte[4];
        if (length < 7) {
            throw new InvalidPduException("Invalid message length (must be 7+): " + length);
        }
        System.arraycopy(frame, 4, data, 0, 4);
        return new PduFirstFrame(Pdu.getNodeAddress(frame), frame[3], data, length);
    }

    public static PduFirstFrame create(byte nodeAddress, byte serviceId, ByteBuffer dataBuffer) throws InvalidPduException {
        PduFirstFrame.validateDataLength(dataBuffer.remaining());
        int dataLength = dataBuffer.remaining();
        byte[] data = new byte[4];
        dataBuffer.get(data);
        return new PduFirstFrame(nodeAddress, serviceId, data, dataLength + 1);
    }

    private static void validateDataLength(int length) throws InvalidPduException {
        if (length < 4) {
            throw new InvalidPduException("Not enough data provided for first frame.");
        }
    }

    private static int getLength(byte pci, byte len) {
        return (pci & 0xF) * 256 + PduFirstFrame.removeSignExtention(len);
    }

    @Override
    public byte[] get() {
        byte protocolControlInformation = (byte)(0x10 | this.totalMessageLength / 256);
        byte[] frame = new byte[]{this.nodeAddress, protocolControlInformation, (byte)this.totalMessageLength, this.serviceId, -1, -1, -1, -1};
        System.arraycopy(this.data, 0, frame, 4, 4);
        return frame;
    }

    @Override
    public byte getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public Pdu.Type getType() {
        return Pdu.Type.FIRST_FRAME;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Optional<Integer> getLength() {
        return Optional.of(this.totalMessageLength);
    }

    @Override
    public Optional<Byte> getServiceId() {
        return Optional.of(this.serviceId);
    }

    @Override
    public Optional<Integer> getSequenceNumber() {
        return Optional.empty();
    }

    private static int removeSignExtention(byte data) {
        return data & 0xFF;
    }
}

