/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import console16bit.Console16bit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import unified.bootloader16bit.BadResponseException;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.ProtocolInUseException;
import unified.bootloader16bit.TimeoutException;
import unified.bootloader16bit.phy.Config;
import unified.bootloader16bit.phy.lin.ConfigImpl;
import unified.bootloader16bit.phy.lin.Controller;
import unified.bootloader16bit.phy.lin.FrameTransceiver;
import unified.bootloader16bit.phy.lin.Message;
import unified.bootloader16bit.phy.lin.Model;
import unified.bootloader16bit.phy.lin.TransportProtocol;
import unified.bootloader16bit.phy.lin.plin.PLinFrameTransceiver;

public class ProtocolLin
implements Protocol {
    private final Console16bit console;
    private final FrameTransceiver lin;
    private boolean isOpen = false;
    private final Model model;
    private final Config<Model, Controller> config;
    private static final String HEX_NUMBER_REGEX = "(0x)?(?<value>[0-9a-fA-F]{1,2})";
    private static final Pattern HEX_NUMBER_PATTERN = Pattern.compile("(0x)?(?<value>[0-9a-fA-F]{1,2})");

    public ProtocolLin(Console16bit console) {
        this(console, new PLinFrameTransceiver(console), new ConfigImpl(), new Model());
        this.model.setPortSupplier(this::getAvailableIds);
    }

    ProtocolLin(Console16bit console, FrameTransceiver lin, Config<Model, Controller> config, Model model) {
        this.console = console;
        this.lin = lin;
        this.config = config;
        this.model = model;
        model.setPortSupplier(this::getAvailableIds);
    }

    @Override
    public void config() {
        try {
            this.config.show(this.model);
            this.reportToConsole();
        }
        catch (IOException ex) {
            this.console.addConsoleText(Level.SEVERE, "Unable to load configuration settings window.");
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.lin.close();
        }
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void open() throws IOException, ProtocolException, ProtocolInUseException {
        this.isOpen = true;
        this.lin.open(this.model.getPort(), this.model.getDataBitRate());
    }

    private byte[] getCommandData(ByteBuffer commandData) {
        ByteBuffer input = commandData.duplicate();
        input.flip();
        byte[] command = new byte[input.remaining()];
        input.get(command);
        return command;
    }

    @Override
    public ByteBuffer transceive(ByteBuffer commandData, Integer responseLength, Integer timeoutMilliseconds) throws IOException, TimeoutException, BadResponseException {
        Message message;
        if (!this.isOpen) {
            throw new IOException("No open driver.");
        }
        TransportProtocol transport = new TransportProtocol(this.lin, this.toByte(this.model.getPublisherId()), this.toByte(this.model.getSubscriberId()));
        if (!transport.sendRequest(message = new Message(this.toByte(this.model.getNodeId()), this.toByte(this.model.getServiceId()), this.getCommandData(commandData)), this.model.getChecksumType())) {
            throw new IOException("Unable to send command to device");
        }
        Instant startTime = Instant.now();
        while (Duration.between(startTime, Instant.now()).toMillis() < (long)timeoutMilliseconds.intValue()) {
            Optional<Message> response = transport.getResponse(this.model.getChecksumType());
            if (!response.isPresent()) continue;
            return ByteBuffer.wrap(response.get().getData());
        }
        throw new TimeoutException();
    }

    @Override
    public String getHardwareMisconfigurationMessage() {
        return "The LIN interface is not property configured.";
    }

    List<String> getAvailableIds() {
        return this.lin.getIds();
    }

    public final void reportToConsole() {
        ArrayList<String> consoleText = new ArrayList<String>();
        consoleText.add("Selected LIN Settings:");
        consoleText.add("  LIN Module: " + this.model.getPort());
        consoleText.add("  Bit rate: " + this.model.getDataBitRate());
        consoleText.add("  Checksum Type: " + (Object)((Object)this.model.getChecksumType()));
        consoleText.add("  Command/Request frame ID: " + this.model.getPublisherId());
        consoleText.add("  Response frame ID: " + this.model.getSubscriberId());
        consoleText.add("  Node address: " + this.model.getNodeId());
        consoleText.add("  Service ID: " + this.model.getServiceId());
        this.console.addConsoleText(Level.CONFIG, consoleText);
    }

    private byte toByte(String input) {
        Matcher matcher = HEX_NUMBER_PATTERN.matcher(input.trim());
        if (matcher.matches()) {
            return (byte)Integer.parseInt(matcher.group("value"), 16);
        }
        return 0;
    }
}

