/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.Message;
import unified.bootloader16bit.phy.lin.Pdu;
import unified.bootloader16bit.phy.lin.PduConsecutiveFrame;
import unified.bootloader16bit.phy.lin.PduFactory;

public class ResponseAssembler {
    private final ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private byte nodeAddress;
    private byte serviceId;
    private int dataLength = 0;
    private boolean isMessageStarted = false;
    private int expectedSequenceNumber = 1;
    private static final int INVALID_SEQUENCE_NUMBER = -1;

    public void addFrame(byte[] frame) {
        Optional<Pdu> pduOptional = PduFactory.getPdu(frame);
        if (pduOptional.isPresent()) {
            Pdu pdu = pduOptional.get();
            this.nodeAddress = pdu.getNodeAddress();
            if (this.isStartOfNewMessage(pdu)) {
                this.terminateExistingMessage();
                this.isMessageStarted = true;
                this.dataLength = pdu.getLength().orElse(this.dataLength);
                this.serviceId = pdu.getServiceId().orElse(this.serviceId);
                this.writeData(pdu.getData());
            } else if (this.isContinuationOfExistingMessage(pdu)) {
                this.expectedSequenceNumber = PduConsecutiveFrame.getNextSequenceNumber(this.expectedSequenceNumber);
                this.writeData(pdu.getData());
            } else {
                this.terminateExistingMessage();
            }
        }
    }

    private void terminateExistingMessage() {
        this.isMessageStarted = false;
        this.dataStream.reset();
        this.expectedSequenceNumber = 1;
    }

    private boolean isContinuationOfExistingMessage(Pdu pdu) {
        if (!pdu.getType().equals((Object)Pdu.Type.CONSECUTIVE_FRAME)) {
            return false;
        }
        return pdu.getSequenceNumber().orElse(-1).equals(this.expectedSequenceNumber);
    }

    private boolean isStartOfNewMessage(Pdu pdu) {
        return pdu.getType().equals((Object)Pdu.Type.FIRST_FRAME) || pdu.getType().equals((Object)Pdu.Type.SINGLE_FRAME);
    }

    private int expectedDataLength() {
        return Math.max(0, this.dataLength - 1);
    }

    public Optional<Message> getMessage() {
        if (!this.isMessageStarted) {
            return Optional.empty();
        }
        if (this.dataStream.size() == 0) {
            return Optional.empty();
        }
        if (this.dataStream.size() < this.expectedDataLength()) {
            return Optional.empty();
        }
        return Optional.of(new Message(this.nodeAddress, this.serviceId, this.dataStream.toByteArray()));
    }

    private void writeData(byte[] data) {
        int dataRemaining = Math.max(0, this.expectedDataLength() - this.dataStream.size());
        int bytesToRead = Math.min(dataRemaining, data.length);
        this.dataStream.write(data, 0, bytesToRead);
    }
}

