/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Options;
import com.azul.crs.client.util.DnsDetect;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.util.Map;

public class ClientProperties {
    private static final String DEFAULT_API_MAILBOX = "default";
    private final Map<Client.ClientProp, Object> properties;

    public ClientProperties(Map<Client.ClientProp, Object> map, long l) throws CRSException {
        boolean bl;
        this.properties = map;
        this.properties.put(Client.ClientProp.CONNECTION_MANAGER, Options.connectionManager.get());
        this.properties.put(Client.ClientProp.VM_SHUTDOWN_DELAY, l);
        if (this.properties.get((Object)Client.ClientProp.API_MAILBOX) == null) {
            this.properties.put(Client.ClientProp.API_MAILBOX, DEFAULT_API_MAILBOX);
        }
        boolean bl2 = bl = this.properties.get((Object)Client.ClientProp.API_URL) != null;
        if (!bl) {
            try {
                DnsDetect dnsDetect = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", dnsDetect.getRecordNamePostfix().length() > 0 ? " (postfix " + dnsDetect.getRecordNamePostfix() + ")" : "");
                String string = dnsDetect.queryEndpoint();
                if (string == null) {
                    throw new CRSException(-1);
                }
                this.properties.put(Client.ClientProp.API_URL, "https://" + string);
            }
            catch (IOException iOException) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", iOException);
            }
        } else {
            String string = (String)this.properties.get((Object)Client.ClientProp.API_URL);
            if (!string.startsWith("https://")) {
                throw new CRSException(-6);
            }
            if (string.endsWith("/")) {
                this.properties.put(Client.ClientProp.API_URL, this.removeTrailingSlashes(string));
            }
        }
    }

    public void validate() {
        for (Client.ClientProp clientProp : Client.ClientProp.values()) {
            if (!clientProp.isMandatory() || this.properties.get((Object)clientProp) != null) continue;
            throw new IllegalArgumentException("Invalid CRS properties file: missing value for " + clientProp.value());
        }
    }

    private String removeTrailingSlashes(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == '/') continue;
            return string.substring(0, i + 1);
        }
        return string;
    }

    public Map<Client.ClientProp, Object> getProperties() {
        return this.properties;
    }
}

