/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.TimeUnit;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class UsbHidTrezorV1Example
implements HidServicesListener {
    static final int PACKET_LENGTH = 64;
    private HidServices hidServices;

    public static void main(String[] args) throws HidException {
        UsbHidTrezorV1Example example = new UsbHidTrezorV1Example();
        example.executeExample();
    }

    public void executeExample() throws HidException {
        System.out.println("Loading hidapi...");
        this.hidServices = HidManager.getHidServices();
        this.hidServices.addHidServicesListener(this);
        System.out.println("Enumerating attached devices...");
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            System.out.println(hidDevice);
        }
        HidDevice trezor = this.hidServices.getHidDevice(21324, 1, null);
        if (trezor != null) {
            this.sendInitialise(trezor);
        } else {
            System.out.println("Waiting for Trezor attach...");
        }
        UsbHidTrezorV1Example.sleepUninterruptibly(5L, TimeUnit.SECONDS);
        if (trezor != null && trezor.isOpen()) {
            trezor.close();
        }
        System.exit(0);
    }

    @Override
    public void hidDeviceAttached(HidServicesEvent event) {
        HidDevice trezor;
        System.out.println("Device attached: " + event);
        if (event.getHidDevice().getVendorId() == 21324 && event.getHidDevice().getProductId() == 1 && (trezor = this.hidServices.getHidDevice(21324, 1, null)) != null) {
            this.sendInitialise(trezor);
        }
    }

    @Override
    public void hidDeviceDetached(HidServicesEvent event) {
        System.err.println("Device detached: " + event);
    }

    @Override
    public void hidFailure(HidServicesEvent event) {
        System.err.println("HID failure: " + event);
    }

    private void sendInitialise(HidDevice trezor) {
        byte[] message = new byte[64];
        message[0] = 63;
        message[1] = 35;
        message[2] = 35;
        int val = trezor.write(message, 64, (byte)0);
        if (val != -1) {
            System.out.println("> [" + val + "]");
        } else {
            System.err.println(trezor.getLastErrorMessage());
        }
        boolean moreData = true;
        block4: while (moreData) {
            byte[] data = new byte[64];
            val = trezor.read(data, 500);
            switch (val) {
                case -1: {
                    System.err.println(trezor.getLastErrorMessage());
                    continue block4;
                }
                case 0: {
                    moreData = false;
                    continue block4;
                }
            }
            System.out.print("< [");
            for (byte b : data) {
                System.out.printf(" %02x", b);
            }
            System.out.println("]");
        }
    }

    public static void sleepUninterruptibly(long sleepFor, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(sleepFor);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

