/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.util.List;
import org.hid4java.HidDevice;
import org.hid4java.HidDeviceManager;
import org.hid4java.HidException;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;

public class HidServices {
    private final HidServicesListenerList listeners = new HidServicesListenerList();
    private final HidDeviceManager deviceManager;

    public HidServices() throws HidException {
        this(true);
    }

    public HidServices(boolean autoShutdown) throws HidException {
        this(autoShutdown, 500);
    }

    public HidServices(boolean autoShutdown, int scanInterval) throws HidException {
        this.deviceManager = new HidDeviceManager(this.listeners, scanInterval);
        this.deviceManager.start();
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                HidServices.this.shutdown();
            }
        };
        if (autoShutdown) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    public void shutdown() {
        this.deviceManager.stop();
        try {
            HidApi.exit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        this.deviceManager.stop();
    }

    public void start() {
        this.deviceManager.start();
    }

    public void start(int scanInterval) {
        this.deviceManager.setScanInterval(scanInterval);
        this.deviceManager.start();
    }

    public void addHidServicesListener(HidServicesListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsbServicesListener(HidServicesListener listener) {
        this.listeners.remove(listener);
    }

    public void scan() {
        this.deviceManager.scan();
    }

    public List<HidDevice> getAttachedHidDevices() {
        return this.deviceManager.getAttachedHidDevices();
    }

    public HidDevice getHidDevice(int vendorId, int productId, String serialNumber) {
        List<HidDevice> devices = this.deviceManager.getAttachedHidDevices();
        for (HidDevice device : devices) {
            if (!device.isVidPidSerial(vendorId, productId, serialNumber)) continue;
            if (device.open()) {
                return device;
            }
            return null;
        }
        return null;
    }
}

