/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.ConsoleFXMLController;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import unified.bootloader8bit.UBoot;

public class Console {
    private static Console consoleApplication = null;
    Stage dialogStage = new Stage();
    UBoot application;
    private static final Logger LOGGER = Logger.getLogger(Console.class.getName());

    private Console(UBoot application) {
        this.application = application;
        try {
            this.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to start Console. " + ex.toString(), ex);
        }
    }

    public static Console getConsole(UBoot application) {
        if (consoleApplication == null) {
            consoleApplication = new Console(application);
            return consoleApplication;
        }
        return consoleApplication;
    }

    public void start() throws Exception {
        Parent node = this.loadFxmlMainForm("ConsoleFXML.fxml");
        this.dialogStage.initModality(Modality.WINDOW_MODAL);
        this.dialogStage.setScene(new Scene(node));
        this.dialogStage.setTitle("Console");
    }

    public void init() throws Exception {
        this.dialogStage.show();
    }

    private Parent loadFxmlMainForm(String file) throws IOException {
        ConsoleFXMLController form = new ConsoleFXMLController(this);
        URL location = this.getClass().getResource(file);
        FXMLLoader loader = new FXMLLoader(location);
        loader.setController((Object)form);
        Object result = loader.load();
        return (Parent)result;
    }
}

