/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import observers.ALoraObserver;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.model.UBootModel;

public class ConsoleFXMLController
implements Initializable {
    Console application;
    @FXML
    private TextArea console;

    public ConsoleFXMLController(Console application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        ContextMenu menu = new ContextMenu();
        MenuItem menuItem = new MenuItem("Clear Log");
        menu.getItems().add((Object)menuItem);
        menu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (((MenuItem)event.getTarget()).getText().contains("Clear")) {
                    ConsoleFXMLController.this.console.clear();
                }
            }
        });
        this.console.setContextMenu(menu);
        this.application.application.getModel().addConsolePropertyChangeListener(new ALoraObserver<UBootModel>(){

            @Override
            public void handleEvent(UBootModel value, String whatChanged) {
                if (whatChanged.compareTo("Console") == 0) {
                    ConsoleFXMLController.this.printf(value);
                }
            }
        });
    }

    public synchronized void printf(final IDeviceModel dev) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ConsoleFXMLController.this.console.appendText(dev.getConsoleText());
            }
        });
    }
}

