/*
 * Decompiled with CFR 0.152.
 */
package console16bit;

import console16bit.Console16bitController;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;

public class ConsoleFXMLController16bit
implements Initializable,
Console16bitController {
    @FXML
    private TextArea console;
    @FXML
    private ChoiceBox logLevelChoiceBox;
    Level currentLogLevel = Level.CONFIG;

    public void initialize(URL url, ResourceBundle rb) {
        ArrayList<Level> levels = new ArrayList<Level>();
        levels.add(Level.SEVERE);
        levels.add(Level.WARNING);
        levels.add(Level.INFO);
        levels.add(Level.CONFIG);
        levels.add(Level.FINE);
        levels.add(Level.FINER);
        levels.add(Level.FINEST);
        this.console.setStyle("-fx-font-family:monospace;");
        ContextMenu menu = new ContextMenu();
        MenuItem clearLogItem = new MenuItem("Clear Log");
        menu.getItems().add((Object)clearLogItem);
        clearLogItem.setOnAction(event -> this.console.clear());
        this.console.setContextMenu(menu);
        ObservableList observableLevels = FXCollections.observableArrayList((Object[])new Object[]{"SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"});
        this.logLevelChoiceBox.getItems().addAll((Collection)observableLevels);
        this.logLevelChoiceBox.getSelectionModel().select((Object)this.currentLogLevel.getName());
        this.logLevelChoiceBox.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> this.setLogLevel((Level)levels.get(newValue.intValue())));
    }

    @Override
    public void setConsoleViewText(String text) {
        this.console.setText(this.console.getText() + text + '\n');
        this.console.appendText("");
        this.console.setScrollTop(Double.MAX_VALUE);
    }

    @Override
    public Level getLogLevel() {
        return this.currentLogLevel;
    }

    @Override
    public void setLogLevel(Level level) {
        this.currentLogLevel = level;
    }
}

