/*
 * Decompiled with CFR 0.152.
 */
package unified.MVController;

import commands.ICommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.event.Event;
import javafx.event.EventHandler;
import task.ALoraTask;
import task.LoraTask;
import unified.MVController.IMVController;

public class MVController
implements IMVController {
    List<EventHandler> observersSuccess = new ArrayList<EventHandler>();
    List<EventHandler> observersFailure = new ArrayList<EventHandler>();
    Map<ALoraTask, List<EventHandler>> observersSuccessTaskMap = new HashMap<ALoraTask, List<EventHandler>>();
    Map<ALoraTask, List<EventHandler>> observersFailureTaskMap = new HashMap<ALoraTask, List<EventHandler>>();
    protected ExecutorService executor = Executors.newFixedThreadPool(1);
    public ALoraTask task = new LoraTask();

    @Override
    public void execute(List<ICommand> commands) {
        this.createNewTask();
        for (ICommand command : commands) {
            this.task.addCommand(command);
        }
        this.task.setOnFailed(new FinalFailedEventHandler(this.task));
        this.task.setOnSucceeded(new FinalSucceededEventHandler(this.task));
        this.executor.execute((Runnable)((Object)this.task));
    }

    @Override
    public void execute(List<ICommand> commands, List<EventHandler> eventHandlersOnFailed, List<EventHandler> eventHandlersOnSucceeded) {
        this.createNewTask();
        this.observersFailureTaskMap.put(this.task, eventHandlersOnFailed);
        this.observersSuccessTaskMap.put(this.task, eventHandlersOnSucceeded);
        for (ICommand command : commands) {
            this.task.addCommand(command);
        }
        this.task.setOnFailed(new FinalFailedEventHandler(this.task));
        this.task.setOnSucceeded(new FinalSucceededEventHandler(this.task));
        this.executor.execute((Runnable)((Object)this.task));
    }

    @Override
    public void afterSuccess(EventHandler observer) {
        this.observersSuccess.add(observer);
    }

    @Override
    public void afterFailure(EventHandler observer) {
        this.observersFailure.add(observer);
    }

    private void createNewTask() {
        this.task = new LoraTask();
    }

    class FinalFailedEventHandler
    implements EventHandler {
        ALoraTask task;

        public FinalFailedEventHandler(ALoraTask task) {
            this.task = task;
        }

        public void handle(Event event) {
            for (EventHandler observer : MVController.this.observersFailure) {
                observer.handle(event);
            }
            if (MVController.this.observersFailureTaskMap.get((Object)this.task) != null) {
                for (EventHandler observer : MVController.this.observersFailureTaskMap.get((Object)this.task)) {
                    observer.handle(event);
                }
            }
            for (int i = MVController.this.observersFailure.size() - 1; i > 0; --i) {
                MVController.this.observersFailure.remove(i);
            }
        }
    }

    class FinalSucceededEventHandler
    implements EventHandler {
        ALoraTask task;

        public FinalSucceededEventHandler(ALoraTask task) {
            this.task = task;
        }

        public void handle(Event event) {
            for (EventHandler observer : MVController.this.observersSuccess) {
                observer.handle(event);
            }
            if (MVController.this.observersSuccessTaskMap.get((Object)this.task) != null) {
                for (EventHandler observer : MVController.this.observersSuccessTaskMap.get((Object)this.task)) {
                    observer.handle(event);
                }
            }
            for (int i = MVController.this.observersSuccess.size() - 1; i > 0; --i) {
                MVController.this.observersSuccess.remove(i);
            }
        }
    }
}

