/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader.model32bit;

import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import observers.ALoraObserver;
import portSettings.model.PortSettingsPojo32bit;
import udpSettings.model.UdpSettingsPojo32bit;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.model.UBootModel;
import unified.bootloader.model32bit.UBootPoJo32bit;
import usbSettings.model.UsbSettingsPojo32bit;

public class UBootModel32bit
implements IDeviceModel {
    public boolean updateValueFlag = true;
    List<ALoraObserver> modelObserver = new ArrayList<ALoraObserver>();
    List<ALoraObserver> consoleObserver = new ArrayList<ALoraObserver>();
    private String deviceName = null;
    private String version = null;
    private List<String> console = new ArrayList<String>();
    private InputStream communicationsInputStream = null;
    private OutputStream communicationsOutputStream = null;
    private I2CSoftwareLibraryCommunicationsInterface communicationsI2C = null;
    public PortSettingsPojo32bit dfuPojo32Bit = new PortSettingsPojo32bit(this);
    public UsbSettingsPojo32bit usbPojo32Bit = new UsbSettingsPojo32bit(this);
    public UdpSettingsPojo32bit udpPojo32Bit = new UdpSettingsPojo32bit(this);
    public UBootPoJo32bit ubootPojo32Bit = new UBootPoJo32bit(this);
    private static final Logger LOGGER = Logger.getLogger(UBootModel.class.getName());

    @Override
    public void setInputStream(InputStream stream) {
        this.communicationsInputStream = stream;
    }

    @Override
    public InputStream getInputStream() {
        if (this.communicationsInputStream == null) {
            LOGGER.log(Level.SEVERE, "InputStream is not Initialized");
            return null;
        }
        return this.communicationsInputStream;
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.communicationsOutputStream = stream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.communicationsInputStream == null) {
            LOGGER.log(Level.SEVERE, "OutputStream is not Initialized");
            return null;
        }
        return this.communicationsOutputStream;
    }

    @Override
    public void injectI2CCommunicationInterface(I2CSoftwareLibraryCommunicationsInterface myI2CComms) {
        this.communicationsI2C = myI2CComms;
    }

    @Override
    public I2CSoftwareLibraryCommunicationsInterface getI2CCommunicationInterface() {
        if (this.communicationsI2C == null) {
            LOGGER.log(Level.SEVERE, "I2C Interface is not Initialized");
            return null;
        }
        return this.communicationsI2C;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Override
    public String getDeviceName() {
        if (this.deviceName != null) {
            return this.deviceName;
        }
        LOGGER.log(Level.SEVERE, "Unnamed device");
        return null;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
        this.callObservers();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public synchronized void setConsoleText(String text) {
        this.console.add(text);
        this.callConsoleObservers();
    }

    public synchronized void setProgress(String text) {
        this.callProgressObservers();
    }

    @Override
    public synchronized String getConsoleText() {
        Iterator<String> iterate = this.console.iterator();
        String element = iterate.next();
        iterate.remove();
        return element;
    }

    @Override
    public void callObservers() {
        for (ALoraObserver observer : this.modelObserver) {
            observer.handleEvent(this, "Property");
        }
    }

    public void callWriteBlockSizeObservers() {
        for (ALoraObserver observer : this.modelObserver) {
            observer.handleEvent(this, "WriteBlockSize");
        }
    }

    @Override
    public void callConsoleObservers() {
        for (ALoraObserver observer : this.consoleObserver) {
            observer.handleEvent(this, "Console");
        }
    }

    public void callProgressObservers() {
        for (ALoraObserver observer : this.consoleObserver) {
            observer.handleEvent(this, "Progress");
        }
    }

    @Override
    public void addPropertyChangeListener(ALoraObserver listener) {
        this.modelObserver.add(listener);
    }

    @Override
    public void addConsolePropertyChangeListener(ALoraObserver listener) {
        this.consoleObserver.add(listener);
    }
}

