/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import unified.bootloader16bit.Bootloader16Model;

public class Bootloader16ModelObserver
implements Observer {
    private final Consumer<Double> progress;
    private final Consumer<String> statusResult;
    private final Consumer<String> configState;
    private final Consumer<Boolean> programDisable;
    private final Consumer<Integer> startAddress;
    private final Consumer<Integer> endAddress;
    private final Consumer<String> protocolType;
    private static Pattern compile = Pattern.compile("(0x)?(?<value>[0-9a-fA-F]{1,8})");

    Bootloader16ModelObserver(Consumer<Double> progress, Consumer<String> statusResult, Consumer<String> configState, Consumer<Boolean> programDisable, Consumer<Integer> startAddress, Consumer<Integer> endAddress, Consumer<String> protocolType) {
        this.progress = progress;
        this.statusResult = statusResult;
        this.configState = configState;
        this.programDisable = programDisable;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.protocolType = protocolType;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Bootloader16Model) {
            Bootloader16Model model = (Bootloader16Model)o;
            this.progress.accept(model.getProgress());
            this.statusResult.accept(model.getStatusResult());
            this.configState.accept(model.getConfigState());
            this.programDisable.accept(model.getProgramDisable());
            this.startAddress.accept(model.getStartAddress());
            this.endAddress.accept(model.getEndAddress());
            this.protocolType.accept(model.getProtocolType().get());
        }
    }

    private static Optional<Integer> getAddress(String addressString) {
        Long address;
        Matcher matcher = compile.matcher(addressString.trim());
        if (matcher.matches() && (address = Long.valueOf(Long.parseLong(matcher.group("value"), 16))) <= Integer.MAX_VALUE) {
            return Optional.of(address.intValue());
        }
        return Optional.empty();
    }

    public static Integer getAddressValue(String oldValue, String newValue) {
        return Bootloader16ModelObserver.getAddress(newValue).orElse(Bootloader16ModelObserver.getAddress(oldValue).orElse(0));
    }
}

