/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.List;
import unified.bootloader16bit.Chonk;
import unified.bootloader16bit.Chunk;

class ChonkImpl
implements Chonk {
    private final List<Chunk> chunks;

    ChonkImpl(List<Chunk> chunks) {
        this.chunks = chunks;
    }

    @Override
    public List<Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    public Integer getAddress() {
        if (this.chunks.isEmpty()) {
            throw new IllegalStateException("Malformed intermediate image component found.");
        }
        return this.chunks.get(0).getAddress();
    }

    @Override
    public List<Integer> getWords() {
        ArrayList<Integer> words = new ArrayList<Integer>();
        for (Chunk c : this.chunks) {
            words.add(c.getLo());
            words.add(c.getHi());
        }
        return words;
    }

    @Override
    public void addChunk(Chunk chunk) {
        this.chunks.add(chunk);
    }
}

