/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.Comparator;
import java.util.List;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandSegment;
import unified.bootloader16bit.FnCommandVisitor;
import unified.bootloader16bit.PropAddressSegment;
import unified.bootloader16bit.PropCommandSegment;
import unified.bootloader16bit.PropDeviceIdSegment;
import unified.bootloader16bit.PropDummySegment;
import unified.bootloader16bit.PropEndAddressSegment;
import unified.bootloader16bit.PropErasePageSizeSegment;
import unified.bootloader16bit.PropLengthSegment;
import unified.bootloader16bit.PropMaxPacketSizeSegment;
import unified.bootloader16bit.PropMinWriteSizeSegment;
import unified.bootloader16bit.PropProgramEndAddressSegment;
import unified.bootloader16bit.PropProgramRegionIdSegment;
import unified.bootloader16bit.PropProgramStartAddressSegment;
import unified.bootloader16bit.PropProgramWordSegment;
import unified.bootloader16bit.PropStartAddressSegment;
import unified.bootloader16bit.PropStatusSegment;
import unified.bootloader16bit.PropUnlockCodeSegment;
import unified.bootloader16bit.PropVersionSegment;

public class FnDeconstructor
implements FnCommandVisitor<List<CommandSegment>> {
    private final List<CommandSegment> segments;
    private Integer seq = 100;

    public FnDeconstructor(List<CommandSegment> segments) {
        this.segments = segments;
    }

    @Override
    public List<CommandSegment> forDummy(Command others, int size) {
        this.segments.add(new PropDummySegment(size));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forVersion(Command others, int version) {
        this.segments.add(new PropVersionSegment(version));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forMinWriteSize(Command others, int minWriteSize) {
        this.segments.add(new PropMinWriteSizeSegment(minWriteSize));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forMaxPacketSize(Command others, int maxPacketSize) {
        this.segments.add(new PropMaxPacketSizeSegment(maxPacketSize));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forErasePageSize(Command others, int erasePageSize) {
        this.segments.add(new PropErasePageSizeSegment(erasePageSize));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forStartAddress(Command others, long startAddress) {
        this.segments.add(new PropStartAddressSegment((int)startAddress));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forEndAddress(Command others, long endAddress) {
        this.segments.add(new PropEndAddressSegment((int)endAddress));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forDeviceId(Command others, int deviceId) {
        this.segments.add(new PropDeviceIdSegment(deviceId));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forBase() {
        this.segments.sort(Comparator.naturalOrder());
        return this.segments;
    }

    @Override
    public List<CommandSegment> forCommand(Command others, int cmd) {
        this.segments.add(new PropCommandSegment(cmd));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forLength(Command others, int length) {
        this.segments.add(new PropLengthSegment(length));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forUnlock(Command others, long unlock) {
        this.segments.add(new PropUnlockCodeSegment((int)unlock));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forAddress(Command others, long address) {
        this.segments.add(new PropAddressSegment((int)address));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forData(Command others, int data) {
        Integer n = this.seq;
        Integer n2 = this.seq = Integer.valueOf(this.seq + 1);
        this.segments.add(new PropProgramWordSegment(data, n));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forStatus(Command others, int status) {
        this.segments.add(new PropStatusSegment(status));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forProgramStartAddress(Command others, long startAddress) {
        this.segments.add(new PropProgramStartAddressSegment((int)startAddress));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forProgramEndAddress(Command others, long endAddress) {
        this.segments.add(new PropProgramEndAddressSegment((int)endAddress));
        return others.accept(this);
    }

    @Override
    public List<CommandSegment> forProgramRegionId(Command others, int regionId) {
        this.segments.add(new PropProgramRegionIdSegment(regionId));
        return others.accept(this);
    }
}

