/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.Map;
import unified.bootloader16bit.Bootloader16Model;
import unified.bootloader16bit.ModelProxy;
import unified.bootloader16bit.hexfile.InvalidRecordException;

class ModelProxyImpl
implements ModelProxy {
    private final Bootloader16Model bootloader16Model;

    ModelProxyImpl(Bootloader16Model bootloader16Model) {
        this.bootloader16Model = bootloader16Model;
    }

    @Override
    public int getApplicationEnd() {
        return this.bootloader16Model.getEndAddress();
    }

    @Override
    public int getApplicationStart() {
        return this.bootloader16Model.getStartAddress();
    }

    @Override
    public Map<Integer, Integer> getFilteredImage() throws InvalidRecordException {
        return this.bootloader16Model.getFilteredImage();
    }

    @Override
    public void setResultStatus(String status) {
        this.bootloader16Model.setStatusResult(status);
    }

    @Override
    public void setProgress(double progress) {
        this.bootloader16Model.setProgress(progress);
    }

    @Override
    public Map<Integer, Integer> getImage() throws InvalidRecordException {
        return this.bootloader16Model.getImage();
    }

    @Override
    public int getPages(int erasePageSize) {
        int memorySize = this.getApplicationEnd() - this.getApplicationStart();
        int pageCount = memorySize / erasePageSize;
        if (memorySize % erasePageSize != 0) {
            ++pageCount;
        }
        return pageCount;
    }

    @Override
    public boolean isResetEnabled() {
        return this.bootloader16Model.isResetEnabled();
    }

    @Override
    public boolean isReadBackVerifyEnabled() {
        return this.bootloader16Model.isReadBackVerifyEnabled();
    }

    @Override
    public boolean isSelfVerifyEnabled() {
        return this.bootloader16Model.isSelfVerifyEnabled();
    }

    @Override
    public void setStartAddress(int address) {
        this.bootloader16Model.setStartAddress(address);
    }

    @Override
    public void setEndAddress(int address) {
        this.bootloader16Model.setEndAddress(address);
    }

    @Override
    public void setMemoryRange(int startAddress, int endAddress) {
        this.bootloader16Model.setMemoryRange(startAddress, endAddress);
    }
}

