/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import console16bit.Console16bit;
import unified.bootloader16bit.BootProtocol;
import unified.bootloader16bit.Bootloader16AbstractFactory;
import unified.bootloader16bit.EventHandler;
import unified.bootloader16bit.ModelProxy;
import unified.bootloader16bit.Protocol;

class ProgramTargetFastImpl
implements Runnable {
    private final ModelProxy model;
    private EventHandler eventHandler;
    private final BootProtocol bootProtocol;

    ProgramTargetFastImpl(ModelProxy model, EventHandler eventHandler, BootProtocol bootProtocol) {
        this.model = model;
        this.eventHandler = eventHandler;
        this.bootProtocol = bootProtocol;
    }

    ProgramTargetFastImpl(Bootloader16AbstractFactory factory, ModelProxy model, Protocol protocol, EventHandler eventHandler, Console16bit console) {
        this(model, eventHandler, new BootProtocol(factory, model, protocol, eventHandler, console));
    }

    @Override
    public void run() {
        try {
            this.bootProtocol.open();
            this.bootProtocol.getVersion();
            this.bootProtocol.erase();
            this.bootProtocol.program();
            if (this.model.isReadBackVerifyEnabled()) {
                this.bootProtocol.readBackVerify();
            }
            if (this.model.isSelfVerifyEnabled()) {
                this.bootProtocol.selfVerify();
            }
            if (this.model.isResetEnabled()) {
                this.bootProtocol.reset();
            }
            this.eventHandler.finishedEverything();
        }
        catch (Exception e) {
            this.eventHandler.exception(e);
        }
        finally {
            this.bootProtocol.close();
        }
    }
}

