/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import unified.bootloader16bit.Segment;
import unified.bootloader16bit.SegmentFactory;
import unified.bootloader16bit.SegmentedImage;

public class SegmentedImageImpl
implements SegmentedImage {
    private final ArrayList<Integer> addresses;
    private final SegmentFactory factory;

    public SegmentedImageImpl(Map<Integer, Integer> image, SegmentFactory factory) {
        this.addresses = new ArrayList<Integer>(image.keySet());
        this.addresses.sort(Comparator.naturalOrder());
        this.factory = factory;
    }

    @Override
    public List<Segment> makeSegments() {
        Integer inclusiveStart = 0;
        Integer exclusiveEnd = 0;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (int index = 0; index < this.addresses.size(); ++index) {
            if (this.isStartOfSegment(index)) {
                inclusiveStart = this.addresses.get(index);
            }
            if (!this.isEndOfSegment(index)) continue;
            exclusiveEnd = this.addresses.get(index) + 2;
            segments.add(this.factory.makeSegment(inclusiveStart, exclusiveEnd));
        }
        return segments;
    }

    private boolean isStartOfSegment(Integer index) {
        if (index == 0) {
            return true;
        }
        return this.isEndOfSegment(index - 1);
    }

    private boolean isEndOfSegment(Integer index) {
        if (!this.isThereANext(index)) {
            return true;
        }
        Integer current = this.addresses.get(index);
        Integer next = this.addresses.get(index + 1);
        return next - current != 2;
    }

    private boolean isThereANext(Integer index) {
        return index + 1 < this.addresses.size();
    }
}

