/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit;

import java.util.ArrayList;
import java.util.List;
import unified.bootloader16bit.Command;
import unified.bootloader16bit.CommandFactory;
import unified.bootloader16bit.CommandFactoryImpl;
import unified.bootloader16bit.FnPrototypeSizeVisitorImpl;
import unified.bootloader16bit.PropCommandBase;
import unified.bootloader16bit.WriteCommandConsumer;

public class WriteCommandConsumerImpl
implements WriteCommandConsumer {
    private final List<Command> commands;
    private Command command;
    private int length = 0;
    private CommandFactory commandFactory = new CommandFactoryImpl();

    public WriteCommandConsumerImpl() {
        this.commands = new ArrayList<Command>();
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public void endPacket() {
        this.command = this.command.setLength(this.length);
        this.commands.add(this.command);
    }

    @Override
    public void addToPacket(Integer value) {
        this.command = this.command.addWord(value);
        this.length += 4;
    }

    @Override
    public void startNewPacket(Integer address, Integer value) {
        this.command = this.getHeader(address).addWord(value);
        this.length = 4;
    }

    private Command getHeader(Integer address) {
        return new PropCommandBase().setCommand(this.commandFactory.getWriteFlashCommandId()).setAddress(address.intValue()).setLength(0).setUnlock(this.commandFactory.getUnlockSequence());
    }

    @Override
    public Integer getHeaderSize() {
        return this.getHeader(0).accept(new FnPrototypeSizeVisitorImpl());
    }
}

