/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.hexfile;

import java.util.Arrays;
import unified.bootloader16bit.FromAscii;
import unified.bootloader16bit.hexfile.InvalidRecordException;

class HexRecord {
    private final Type type;
    private final int address;
    private final byte[] data;
    private static final int DATA_FIRST_NIBBLE_OFFSET = 9;
    private static final int DATA_LENGTH_UPPER_NIBBLE_OFFSET = 1;
    private static final int DATA_LENGTH_LOWER_NIBBLE_OFFSET = 2;
    private static final int TYPE_UPPER_NIBBLE_OFFSET = 7;
    private static final int TYPE_LOWER_NIBBLE_OFFSET = 8;
    private static final int ADDRESS_UPPER_NIBBLE_OFFSET = 3;
    private static final int ADDRESS_LOWER_NIBBLE_OFFSET = 6;
    private static final int MINIMUM_RECORD_LENGTH = 11;
    private static final String MISSING_START_OF_RECORD = "Record was missing the start of record marker.";
    private static final String RECORD_TOO_SHORT = "Record was too short to contain all required fields.";
    private static final String INVALID_RECORD_TYPE = "The record type specified was invalid.";
    private static final String INVALID_CHECKSUM = "The checksum for the record was invalid.";
    private static final String INVALID_RECORD_LENGTH = "The record length was invalid.";

    private HexRecord(Type type, int address, byte[] data) {
        this.type = type;
        this.address = address;
        this.data = data;
    }

    public static HexRecord create(String recordString) throws InvalidRecordException {
        if (recordString == null) {
            throw new InvalidRecordException("", MISSING_START_OF_RECORD);
        }
        if (recordString.length() < 11) {
            throw new InvalidRecordException(recordString, RECORD_TOO_SHORT);
        }
        if (recordString.charAt(0) != ':') {
            throw new InvalidRecordException(recordString, MISSING_START_OF_RECORD);
        }
        if (HexRecord.isEven(recordString.length())) {
            throw new InvalidRecordException(recordString, INVALID_RECORD_LENGTH);
        }
        if (!HexRecord.isChecksumValid(recordString)) {
            throw new InvalidRecordException(recordString, INVALID_CHECKSUM);
        }
        return new HexRecord(HexRecord.parseType(recordString), HexRecord.parseAddress(recordString), HexRecord.parseData(recordString));
    }

    private static int parseAddress(String recordString) {
        return FromAscii.toInt16(recordString.substring(3, 7));
    }

    private static Type parseType(String recordString) throws InvalidRecordException {
        Type type = Type.getType(FromAscii.toByte(recordString.substring(7, 9)));
        if (type.equals((Object)Type.INVALID_CODE)) {
            throw new InvalidRecordException(recordString, INVALID_RECORD_TYPE);
        }
        return type;
    }

    private static byte[] parseData(String recordString) throws InvalidRecordException {
        int nibblesPerByte = 2;
        int dataLength = FromAscii.toByte(recordString.substring(1, 3));
        if (dataLength * 2 + 11 != recordString.length()) {
            throw new InvalidRecordException(recordString, INVALID_RECORD_LENGTH);
        }
        byte[] data = new byte[dataLength];
        int offset = 9;
        for (int i = 0; i < dataLength; ++i) {
            data[i] = FromAscii.toByte(recordString.substring(offset, offset + 2));
            offset += 2;
        }
        return data;
    }

    private static boolean isChecksumValid(String recordString) {
        byte checksum = 0;
        for (int i = 1; i < recordString.length(); i += 2) {
            checksum = (byte)(checksum + FromAscii.toByte(recordString.substring(i, i + 2)));
        }
        return checksum == 0;
    }

    byte[] getData() {
        return this.data;
    }

    int getAddress() {
        return this.address;
    }

    Type getType() {
        return this.type;
    }

    private static boolean isEven(int number) {
        return number % 2 == 0;
    }

    static enum Type {
        DATA(0),
        END_OF_FILE(1),
        EXTENDED_SEGMENT_ADDRESS(2),
        START_SEGMENT_ADDRESS(3),
        EXTENDED_LINEAR_ADDRESS(4),
        START_LINEAR_ADDRESS(5),
        INVALID_CODE(-1);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static Type getType(int code) {
            return Arrays.asList(Type.values()).stream().filter(type -> type.getCode() == code).findFirst().orElse(INVALID_CODE);
        }
    }
}

