/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.util.LinkedHashMap;
import java.util.Map;

final class CanPeakIdentifier {
    private static final Map<String, Integer> preferredIds = new LinkedHashMap<String, Integer>();
    private static final Map<String, Integer> allIds = new LinkedHashMap<String, Integer>();

    private CanPeakIdentifier() {
    }

    static String getString(Integer id) {
        for (Map.Entry<String, Integer> entry : allIds.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    static Integer getId(String name) {
        return allIds.get(name);
    }

    static Map<String, Integer> getAllIds() {
        return new LinkedHashMap<String, Integer>(allIds);
    }

    static Map<String, Integer> getPreferredIds() {
        return new LinkedHashMap<String, Integer>(preferredIds);
    }

    static {
        preferredIds.put("PCAN_USBBUS1", 81);
        preferredIds.put("PCAN_USBBUS2", 82);
        preferredIds.put("PCAN_USBBUS3", 83);
        preferredIds.put("PCAN_USBBUS4", 84);
        preferredIds.put("PCAN_PCIBUS1", 65);
        preferredIds.put("PCAN_PCIBUS2", 66);
        preferredIds.put("PCAN_PCIBUS3", 67);
        preferredIds.put("PCAN_PCIBUS4", 68);
        preferredIds.put("PCAN_PCCBUS1", 97);
        preferredIds.put("PCAN_PCCBUS2", 98);
        preferredIds.put("PCAN_LANBUS1", 2049);
        preferredIds.put("PCAN_LANBUS2", 2050);
        preferredIds.put("PCAN_LANBUS3", 2051);
        preferredIds.put("PCAN_LANBUS4", 2052);
        allIds.put("PCAN_USBBUS1", 81);
        allIds.put("PCAN_USBBUS2", 82);
        allIds.put("PCAN_USBBUS3", 83);
        allIds.put("PCAN_USBBUS4", 84);
        allIds.put("PCAN_USBBUS5", 85);
        allIds.put("PCAN_USBBUS6", 86);
        allIds.put("PCAN_USBBUS7", 87);
        allIds.put("PCAN_USBBUS8", 88);
        allIds.put("PCAN_USBBUS9", 1289);
        allIds.put("PCAN_USBBUS10", 1290);
        allIds.put("PCAN_USBBUS11", 1291);
        allIds.put("PCAN_USBBUS12", 1292);
        allIds.put("PCAN_USBBUS13", 1293);
        allIds.put("PCAN_USBBUS14", 1294);
        allIds.put("PCAN_USBBUS15", 1295);
        allIds.put("PCAN_USBBUS16", 1296);
        allIds.put("PCAN_ISABUS1", 33);
        allIds.put("PCAN_ISABUS2", 34);
        allIds.put("PCAN_ISABUS3", 35);
        allIds.put("PCAN_ISABUS4", 36);
        allIds.put("PCAN_ISABUS5", 37);
        allIds.put("PCAN_ISABUS6", 38);
        allIds.put("PCAN_ISABUS7", 39);
        allIds.put("PCAN_ISABUS8", 40);
        allIds.put("PCAN_DNGLPT", 49);
        allIds.put("PCAN_PCIBUS1", 65);
        allIds.put("PCAN_PCIBUS2", 66);
        allIds.put("PCAN_PCIBUS3", 67);
        allIds.put("PCAN_PCIBUS4", 68);
        allIds.put("PCAN_PCIBUS5", 69);
        allIds.put("PCAN_PCIBUS6", 70);
        allIds.put("PCAN_PCIBUS7", 71);
        allIds.put("PCAN_PCIBUS8", 72);
        allIds.put("PCAN_PCIBUS9", 1033);
        allIds.put("PCAN_PCIBUS10", 1034);
        allIds.put("PCAN_PCIBUS11", 1035);
        allIds.put("PCAN_PCIBUS12", 1036);
        allIds.put("PCAN_PCIBUS13", 1037);
        allIds.put("PCAN_PCIBUS14", 1038);
        allIds.put("PCAN_PCIBUS15", 1039);
        allIds.put("PCAN_PCIBUS16", 1040);
        allIds.put("PCAN_PCCBUS1", 97);
        allIds.put("PCAN_PCCBUS2", 98);
        allIds.put("PCAN_LANBUS1", 2049);
        allIds.put("PCAN_LANBUS2", 2050);
        allIds.put("PCAN_LANBUS3", 2051);
        allIds.put("PCAN_LANBUS4", 2052);
        allIds.put("PCAN_LANBUS5", 2053);
        allIds.put("PCAN_LANBUS6", 2054);
        allIds.put("PCAN_LANBUS7", 2055);
        allIds.put("PCAN_LANBUS8", 2056);
        allIds.put("PCAN_LANBUS9", 2057);
        allIds.put("PCAN_LANBUS10", 2058);
        allIds.put("PCAN_LANBUS11", 2059);
        allIds.put("PCAN_LANBUS12", 2060);
        allIds.put("PCAN_LANBUS13", 2061);
        allIds.put("PCAN_LANBUS14", 2062);
        allIds.put("PCAN_LANBUS15", 2063);
        allIds.put("PCAN_LANBUS16", 2064);
    }
}

