/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageFormat {
    private final String description;
    private final String regex;
    private final Integer upperLimit;
    private final Type type;
    static final MessageFormat EXTENDED = new MessageFormat("Extended ID (29-bit)", "(0x)?(?<value>[0-9a-fA-F]{1,8})[x]?", 0x1FFFFFFF, Type.EXTENDED);
    static final MessageFormat STANDARD = new MessageFormat("Standard ID (11-bit)", "(0x)?(?<value>[0-9a-fA-F]{1,8})", (Integer)Short.MAX_VALUE, Type.STANDARD);

    private MessageFormat(String description, String regex, Integer upperLimit, Type type) {
        this.description = description;
        this.regex = regex;
        this.upperLimit = upperLimit;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRangeString() {
        return "0x0-0x" + Integer.toHexString(this.upperLimit).toUpperCase();
    }

    public Optional<Integer> getId(String id) {
        Pattern compile = Pattern.compile(this.regex);
        Matcher matcher = compile.matcher(id.trim());
        if (matcher.matches()) {
            Integer value;
            try {
                value = Integer.parseInt(matcher.group("value"), 16);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
            if (value <= this.upperLimit) {
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }

    public boolean isValidString(String id) {
        return this.getId(id).isPresent();
    }

    public boolean isNumber(String id) {
        return id.trim().matches("(0x)?[0-9a-fA-F]+[x]?");
    }

    public String toString() {
        return this.getDescription();
    }

    Type getType() {
        return this.type;
    }

    static enum Type {
        STANDARD,
        EXTENDED;

    }
}

