/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.can;

import console16bit.Console16bit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import unified.bootloader16bit.OperatingSystem;
import unified.bootloader16bit.Protocol;
import unified.bootloader16bit.ProtocolException;
import unified.bootloader16bit.phy.Bitrate;
import unified.bootloader16bit.phy.Config;
import unified.bootloader16bit.phy.can.CanMapping;
import unified.bootloader16bit.phy.can.CanNetAddrInfo;
import unified.bootloader16bit.phy.can.CanPeakFDInitString;
import unified.bootloader16bit.phy.can.CanPeakIdentifier;
import unified.bootloader16bit.phy.can.ConfigImpl;
import unified.bootloader16bit.phy.can.Controller;
import unified.bootloader16bit.phy.can.DLLWrapper;
import unified.bootloader16bit.phy.can.DLLWrapperImpl;
import unified.bootloader16bit.phy.can.DLLWrapperNotLoaded;
import unified.bootloader16bit.phy.can.MessageFormat;
import unified.bootloader16bit.phy.can.Model;

public class ProtocolCan
implements Protocol {
    private final Console16bit console;
    private final Model model;
    private final DLLWrapper tp;
    private final Config<Model, Controller> config;
    private final ByteBuffer in;
    private final ByteBuffer out;
    static final String BAD_CONNECTION_DETAILS = "Verify that the correct protocol generator, bitrate, and message IDs are selected in the Settings->CAN menu.";
    private static final EnumMap<MessageFormat.Type, Integer> canIdFormatMapping = new EnumMap(MessageFormat.Type.class);
    private static final int PCANTP_CAN_MSGTYPE_STANDARD = 0;
    private static final int PCANTP_CAN_MSGTYPE_EXTENDED = 2;
    private static final int PCANTP_CAN_MSGTYPE_FD = 4;
    private static final int PCANTP_CAN_MSGTYPE_BRS = 8;
    private static final int PCANTP_ISOTP_FORMAT_NORMAL = 1;
    private static final int PCANTP_ISOTP_MSGTYPE_DIAGNOSTIC = 1;
    private static final int PCANTP_ISOTP_ADDRESSING_PHYSICAL = 1;
    private int canId = 0;
    private int canIdFlowCtrl = 0;
    static final String CAN_ONLY_ON_WINDOWS_ERROR = "The CAN driver used currently is only supported in Windows.  Please use a Windows machine to use the CAN protocol.";
    static final String DLL_FAILED_TO_LOAD = "The required CAN drivers failed to load.  They may be missing, corrupted, or unavailable.";

    private static DLLWrapper getDLLWrapper(Consumer<ProtocolException> handler) {
        try {
            if (OperatingSystem.isWindows()) {
                return new DLLWrapperImpl();
            }
            handler.accept(new ProtocolException(CAN_ONLY_ON_WINDOWS_ERROR));
        }
        catch (NoClassDefFoundError ex) {
            handler.accept(new ProtocolException(DLL_FAILED_TO_LOAD));
        }
        catch (ProtocolException ex) {
            handler.accept(ex);
        }
        return new DLLWrapperNotLoaded();
    }

    public ProtocolCan(Console16bit console, Consumer<ProtocolException> handler) {
        this(console, ProtocolCan.getDLLWrapper(handler), new ConfigImpl());
    }

    ProtocolCan(Console16bit console, DLLWrapper wrapper, Config<Model, Controller> config) {
        this(console, wrapper, config, new Model());
        this.model.setPortSupplier(this::getAvailableIds);
    }

    ProtocolCan(Console16bit console, DLLWrapper wrapper, Config<Model, Controller> config, Model model) {
        this.console = console;
        this.tp = wrapper;
        this.config = config;
        this.model = model;
        this.in = ByteBuffer.allocate(10000);
        this.in.order(ByteOrder.LITTLE_ENDIAN);
        this.out = ByteBuffer.allocate(10000);
        this.out.order(ByteOrder.LITTLE_ENDIAN);
    }

    private void printDllLog(Level level) {
        ArrayList<String> consoleText = new ArrayList<String>();
        while (this.tp.getDllLogSize() > 0) {
            consoleText.add(this.tp.getDllLogString());
        }
        this.console.addConsoleText(level, "DLL:" + consoleText);
    }

    @Override
    public void config() {
        try {
            this.config.show(this.model);
            this.reportToConsole();
        }
        catch (IOException ex) {
            this.console.addConsoleText(Level.SEVERE, "Unable to load configuration settings window.");
        }
    }

    @Override
    public void close() {
        this.tp.uninitialize();
        this.printDllLog(Level.FINEST);
    }

    @Override
    public boolean ready() {
        return this.model.isPortSelected();
    }

    private void setCanId(Integer id) {
        this.canId = id;
    }

    private void setIdFlowCtrl(Integer id) {
        this.canIdFlowCtrl = id;
    }

    @Override
    public void open() throws ProtocolException {
        int canIdType = this.getCanIdType();
        if (this.model.isCanFdEnabled()) {
            CanPeakFDInitString.CANPeakFDInitStringBuilder builder = new CanPeakFDInitString.CANPeakFDInitStringBuilder();
            CanPeakFDInitString canParameters = builder.withNominalRate(this.model.getNominalBitRate()).withDataRate(this.model.getDataBitRate()).build();
            this.console.addConsoleText(Level.FINE, "Peak CAN-FD Config String: " + canParameters.get());
            this.in.clear();
            this.in.put(canParameters.get().getBytes());
            this.in.flip();
            canIdType += 12;
            this.tp.initializeFd(CanPeakIdentifier.getId(this.model.getPort()), this.in);
        } else {
            this.console.addConsoleText(Level.FINE, "Configuring Peak CAN Controller : " + this.model.getPort() + ", Baud Rate: " + this.model.getNominalBitRate().toString());
            this.tp.initialize(CanPeakIdentifier.getId(this.model.getPort()), this.model.getNominalBitRate());
        }
        String consoleText = "Peak DLL Version = " + this.tp.getPeakDllVersion() + "\n";
        consoleText = consoleText + "   ubhapeakcanadapterdll Build Date = " + this.tp.getDllBuildDate();
        this.console.addConsoleText(Level.FINE, consoleText);
        Integer dlc = this.getDlc(this.model.getTxDL());
        this.model.getMessageFormat().getId(this.model.getHostToDeviceId()).ifPresent(this::setCanId);
        this.model.getMessageFormat().getId(this.model.getDeviceToHostId()).ifPresent(this::setIdFlowCtrl);
        int format = 1;
        int msgtype = 1;
        int targetType = 1;
        int sourceAddr = 241;
        int targetAddr = 1;
        int extensionAddr = 0;
        CanMapping mapping = new CanMapping(this.canId, this.canIdFlowCtrl, canIdType, dlc, new CanNetAddrInfo(extensionAddr, format, msgtype, sourceAddr, targetAddr, targetType));
        this.printDllLog(Level.FINEST);
        CanMapping reverse = new CanMapping(mapping.getCanIdFlowCtrl(), mapping.getCanId(), canIdType, dlc, new CanNetAddrInfo(extensionAddr, format, msgtype, mapping.getCanNetAddrInfo().getTargetAddr(), mapping.getCanNetAddrInfo().getSourceAddr(), targetType));
        this.tp.setMapping(mapping);
        this.tp.addMapping();
        this.tp.setMapping(reverse);
        this.tp.addMapping();
        this.tp.setMapping(mapping);
    }

    private Integer getCanIdType() {
        return canIdFormatMapping.get((Object)this.model.getMessageFormat().getType());
    }

    @Override
    public ByteBuffer transceive(ByteBuffer commandData, Integer responseLength, Integer timeoutMilliseconds) {
        ByteBuffer input = commandData.duplicate();
        input.flip();
        this.out.clear();
        this.tp.transceive(input, this.out, timeoutMilliseconds);
        this.out.flip();
        return this.out.duplicate();
    }

    @Override
    public String getHardwareMisconfigurationMessage() {
        return BAD_CONNECTION_DETAILS;
    }

    private String reportHardwareSettings() {
        String canType = this.model.isCanFdEnabled() ? "CAN-FD" : "CAN";
        String textToConsole = "Selected " + canType + " Module and Settings: " + this.model.getPort() + ", Nominal Bitrate = " + new Bitrate(this.model.getNominalBitRate()).toString();
        if (this.model.isCanFdEnabled()) {
            textToConsole = textToConsole + ", TX Data Length = " + this.model.getTxDL();
            if (this.model.isDataBitRateEnabled()) {
                textToConsole = textToConsole + ", Data Bitrate = " + new Bitrate(this.model.getDataBitRate()).toString();
            }
        }
        return textToConsole;
    }

    private void reportCANTPMessageIds() {
        ArrayList<String> consoleText = new ArrayList<String>();
        consoleText.add(this.reportHardwareSettings());
        consoleText.add("Host to Device CAN IDs: Messages = " + this.model.getHostToDeviceId() + ", Flow Control = " + this.model.getHostToDeviceId());
        consoleText.add("Device to Host CAN IDs: Messages = " + this.model.getDeviceToHostId() + ", Flow Control = " + this.model.getDeviceToHostId());
        this.console.addConsoleText(Level.CONFIG, consoleText);
    }

    public final void reportToConsole() {
        this.reportCANTPMessageIds();
    }

    boolean isHardwareAvailable(int handle) {
        return this.tp.isHardwareAvailable(handle) == 0;
    }

    List<String> getAvailableIds() {
        Map<String, Integer> possibleIds = CanPeakIdentifier.getPreferredIds();
        LinkedHashMap<String, Integer> availableIds = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> currentId : possibleIds.entrySet()) {
            if (!this.isHardwareAvailable(currentId.getValue())) continue;
            availableIds.put(currentId.getKey(), currentId.getValue());
        }
        return new ArrayList<String>(availableIds.keySet());
    }

    Integer getDlc(Integer txdl) throws ProtocolException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        map.put(2, 2);
        map.put(3, 3);
        map.put(4, 4);
        map.put(5, 5);
        map.put(6, 6);
        map.put(7, 7);
        map.put(8, 8);
        map.put(12, 9);
        map.put(16, 10);
        map.put(20, 11);
        map.put(24, 12);
        map.put(32, 13);
        map.put(48, 14);
        map.put(64, 15);
        Integer dlc = (Integer)map.get(txdl);
        if (dlc == null) {
            throw new ProtocolException("Invalid TXDL provided (" + txdl.toString() + ")");
        }
        return dlc;
    }

    static {
        canIdFormatMapping.put(MessageFormat.Type.EXTENDED, 2);
        canIdFormatMapping.put(MessageFormat.Type.STANDARD, 0);
    }
}

