/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.i2c;

import com.microchip.mcp2221.HidFeatures;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import unified.bootloader16bit.phy.i2c.DLLWrapper;

public class DLLWrapperImpl
implements DLLWrapper {
    private static final Logger LOGGER = Logger.getLogger(DLLWrapperImpl.class.getName());
    final HidFeatures dll = new HidFeatures();

    DLLWrapperImpl() {
    }

    @Override
    public int loadDll() {
        return this.dll.Mcp2221_LoadDll();
    }

    @Override
    public String getLibraryVersion() {
        return this.dll.Mcp2221_GetLibraryVersion();
    }

    @Override
    public int getConnectedDevices(int vid, int pid) {
        return this.dll.Mcp2221_GetConnectedDevices(vid, pid);
    }

    @Override
    public long openByIndex(int vid, int pid, int index) {
        return this.dll.Mcp2221_OpenByIndex(vid, pid, index);
    }

    @Override
    public long openBySN(int vid, int pid, String serialNumber) {
        return this.dll.Mcp2221_OpenBySN(vid, pid, serialNumber);
    }

    @Override
    public int close(long handle) {
        return this.dll.Mcp2221_Close(handle);
    }

    @Override
    public int closeAll() {
        return this.dll.Mcp2221_CloseAll();
    }

    @Override
    public int reset(long handle) {
        return this.dll.Mcp2221_Reset(handle);
    }

    @Override
    public int setSpeed(long handle, int speed) {
        return this.dll.Mcp2221_SetSpeed(handle, speed);
    }

    @Override
    public int setAdvancedCommParams(long handle, short timeout, short maxRetries) {
        return this.dll.Mcp2221_SetAdvancedCommParams(handle, timeout, maxRetries);
    }

    @Override
    public int i2cCancelCurrentTransfer(long handle) {
        return this.dll.Mcp2221_I2cCancelCurrentTransfer(handle);
    }

    @Override
    public int i2cRead(long handle, int bytesToRead, byte slaveAddress, boolean use7bitAddress, byte[] i2cRxData) {
        return this.dll.Mcp2221_I2cRead(handle, bytesToRead, slaveAddress, use7bitAddress, i2cRxData);
    }

    @Override
    public int i2cWrite(long handle, int bytesToWrite, byte slaveAddress, boolean use7bitAddress, byte[] i2cTxData) {
        return this.dll.Mcp2221_I2cWrite(handle, bytesToWrite, slaveAddress, use7bitAddress, i2cTxData);
    }

    @Override
    public int smbusWriteByte(long handle, byte slaveAddress, boolean use7bitAddress, boolean usePec, byte command, byte dataToWrite) {
        return this.dll.Mcp2221_SmbusWriteByte(handle, slaveAddress, use7bitAddress, usePec, command, dataToWrite);
    }

    @Override
    public int smbusReadByte(long handle, byte slaveAddrress, boolean use7bitAddress, boolean usePec, byte command, byte[] dataToRead) {
        return this.dll.Mcp2221_SmbusReadByte(handle, slaveAddrress, use7bitAddress, usePec, command, dataToRead);
    }

    @Override
    public int smbusWriteWord(long handle, byte slaveAdrress, boolean use7bitAddress, boolean usePec, byte command, byte[] dataToWrite) {
        return this.dll.Mcp2221_SmbusWriteWord(handle, slaveAdrress, use7bitAddress, usePec, command, dataToWrite);
    }

    @Override
    public int smbusReadWord(long handle, byte slaveAddress, boolean use7bitAddress, boolean usePec, byte command, byte[] dataToRead) {
        return this.dll.Mcp2221_SmbusReadWord(handle, slaveAddress, use7bitAddress, usePec, command, dataToRead);
    }

    @Override
    public int smbusBlockWrite(long handle, byte slaveAddress, boolean use7bitAddress, boolean usePec, byte command, short byteCount, byte[] dataToWrite) {
        return this.dll.Mcp2221_SmbusBlockWrite(handle, slaveAddress, use7bitAddress, usePec, command, byteCount, dataToWrite);
    }

    @Override
    public int smbusBlockRead(long handle, byte slaveAddress, boolean use7bitAddress, boolean usePec, byte command, short byteCount, byte[] dataToRead) {
        return this.dll.Mcp2221_SmbusBlockRead(handle, slaveAddress, use7bitAddress, usePec, command, byteCount, dataToRead);
    }

    @Override
    public String getManufacturerDescriptor(long handle) {
        return this.dll.Mcp2221_GetManufacturerDescriptor(handle);
    }

    @Override
    public int setManufacturerDescriptor(long handle, String manufacturerString) {
        return this.dll.Mcp2221_SetManufacturerDescriptor(handle, manufacturerString);
    }

    @Override
    public String getProductDescriptor(long handle) {
        return this.dll.Mcp2221_GetProductDescriptor(handle);
    }

    @Override
    public int setProductDescriptor(long handle, String productString) {
        return this.dll.Mcp2221_SetProductDescriptor(handle, productString);
    }

    @Override
    public String getSerialNumberDescriptor(long handle) {
        return this.dll.Mcp2221_GetSerialNumberDescriptor(handle);
    }

    @Override
    public int setSerialNumberDescriptor(long handle, String serialNumber) {
        return this.dll.Mcp2221_SetSerialNumberDescriptor(handle, serialNumber);
    }

    @Override
    public String getFactorySerialNumber(long handle) {
        return this.dll.Mcp2221_GetFactorySerialNumber(handle);
    }

    @Override
    public int getVidPid(long handle, int[] vid, int[] pid) {
        return this.dll.Mcp2221_GetVidPid(handle, vid, pid);
    }

    @Override
    public int setVidPid(long handle, int vid, int pid) {
        return this.dll.Mcp2221_SetVidPid(handle, vid, pid);
    }

    @Override
    public int getInitialPinValues(long handle, byte[] ledUtxInitVal, byte[] ledUrxInitVal, byte[] ledI2cInitVal, byte[] sspndInitVal, byte[] usbCfgInitVal) {
        return this.dll.Mcp2221_GetInitialPinValues(handle, ledUtxInitVal, ledUrxInitVal, ledI2cInitVal, sspndInitVal, usbCfgInitVal);
    }

    @Override
    public int setInitialPinValues(long handle, byte ledUtxInitVal, byte ledUrxInitVal, byte ledI2cInitVal, byte sspndInitVal, byte usbCfgInitVal) {
        return this.dll.Mcp2221_SetInitialPinValues(handle, ledUtxInitVal, ledUrxInitVal, ledI2cInitVal, sspndInitVal, usbCfgInitVal);
    }

    @Override
    public int getUsbPowerAttributes(long handle, short[] powerAttributes, int[] currentReq) {
        return this.dll.Mcp2221_GetUsbPowerAttributes(handle, powerAttributes, currentReq);
    }

    @Override
    public int setUsbPowerAttributes(long handle, short powerAttributes, int currentReq) {
        return this.dll.Mcp2221_SetUsbPowerAttributes(handle, powerAttributes, currentReq);
    }

    @Override
    public int getSerialNumberEnumerationEnable(long handle, byte[] snEnumEnabled) {
        return this.dll.Mcp2221_GetSerialNumberEnumerationEnable(handle, snEnumEnabled);
    }

    @Override
    public int setSerialNumberEnumerationEnable(long handle, byte snEnumEnabled) {
        return this.dll.Mcp2221_SetSerialNumberEnumerationEnable(handle, snEnumEnabled);
    }

    @Override
    public int getSecuritySetting(long handle, byte[] securitySetting) {
        return this.dll.Mcp2221_GetSecuritySetting(handle, securitySetting);
    }

    @Override
    public int setSecuritySetting(long handle, byte securitySetting, String currentPassword, String newPassword) {
        return this.dll.Mcp2221_SetSecuritySetting(handle, securitySetting, currentPassword, newPassword);
    }

    @Override
    public int setPermanentLock(long handle) {
        return this.dll.Mcp2221_SetPermanentLock(handle);
    }

    @Override
    public int sendPassword(long handle, String password) {
        return this.dll.Mcp2221_SendPassword(handle, password);
    }

    @Override
    public int getInterruptEdgeSetting(long handle, byte whichToGet, byte[] interruptPinMode) {
        return this.dll.Mcp2221_GetInterruptEdgeSetting(handle, whichToGet, interruptPinMode);
    }

    @Override
    public int setInterruptEdgeSetting(long handle, byte whichToSet, byte interruptPinMode) {
        return this.dll.Mcp2221_SetInterruptEdgeSetting(handle, whichToSet, interruptPinMode);
    }

    @Override
    public int clearInterruptPinFlag(long handle) {
        return this.dll.Mcp2221_ClearInterruptPinFlag(handle);
    }

    @Override
    public int getInterruptPinFlag(long handle, byte[] flagValue) {
        return this.dll.Mcp2221_GetInterruptPinFlag(handle, flagValue);
    }

    @Override
    public String getHardwareRevision(long handle) {
        return this.dll.Mcp2221_GetHardwareRevision(handle);
    }

    @Override
    public String getFirmwareRevision(long handle) {
        return this.dll.Mcp2221_GetFirmwareRevision(handle);
    }

    @Override
    public int getClockSettings(long handle, byte whichToGet, byte[] dutyCycle, byte[] clockDivider) {
        return this.dll.Mcp2221_GetClockSettings(handle, whichToGet, dutyCycle, clockDivider);
    }

    @Override
    public int setClockSettings(long handle, byte whichToSet, byte dutyCycle, byte clockDivider) {
        return this.dll.Mcp2221_SetClockSettings(handle, whichToSet, dutyCycle, clockDivider);
    }

    @Override
    public int getGpioSettings(long handle, byte whichToGet, byte[] pinFunctions, byte[] pinDirections, byte[] outputValues) {
        return this.dll.Mcp2221_GetGpioSettings(handle, whichToGet, pinFunctions, pinDirections, outputValues);
    }

    @Override
    public int setGpioSettings(long handle, byte whichToSet, byte[] pinFunctions, byte[] pinDirections, byte[] outputValues) {
        return this.dll.Mcp2221_SetGpioSettings(handle, whichToSet, pinFunctions, pinDirections, outputValues);
    }

    @Override
    public int getGpioValues(long handle, byte[] gpioValues) {
        return this.dll.Mcp2221_GetGpioValues(handle, gpioValues);
    }

    @Override
    public int setGpioValues(long handle, byte[] gpioValues) {
        return this.dll.Mcp2221_SetGpioValues(handle, gpioValues);
    }

    @Override
    public int getGpioDirection(long handle, byte[] gpioDir) {
        return this.dll.Mcp2221_GetGpioDirection(handle, gpioDir);
    }

    @Override
    public int setGpioDirection(long handle, byte[] gpioDir) {
        return this.dll.Mcp2221_SetGpioDirection(handle, gpioDir);
    }

    @Override
    public int getDacVref(long handle, byte whichToGet, byte[] dacVref) {
        return this.dll.Mcp2221_GetDacVref(handle, whichToGet, dacVref);
    }

    @Override
    public int setDacVref(long handle, byte whichToSet, byte dacVref) {
        return this.dll.Mcp2221_SetDacVref(handle, whichToSet, dacVref);
    }

    @Override
    public int getDacValue(long handle, byte whichToGet, byte[] dacValue) {
        return this.dll.Mcp2221_GetDacValue(handle, whichToGet, dacValue);
    }

    @Override
    public int setDacValue(long handle, byte whichToSet, byte dacValue) {
        return this.dll.Mcp2221_SetDacValue(handle, whichToSet, dacValue);
    }

    @Override
    public int getAdcVref(long handle, byte whichToGet, byte[] adcVref) {
        return this.dll.Mcp2221_GetAdcVref(handle, whichToGet, adcVref);
    }

    @Override
    public int setAdcVref(long handle, byte whichToSet, byte adcVref) {
        return this.dll.Mcp2221_SetAdcVref(handle, whichToSet, adcVref);
    }

    @Override
    public int getAdcData(long handle, int[] adcData) {
        return this.dll.Mcp2221_GetAdcData(handle, adcData);
    }

    @Override
    public int getLastError() {
        return this.dll.Mcp2221_GetLastError();
    }

    static {
        String userDir = System.getProperty("user.dir");
        Path userDirPath = Paths.get(userDir, new String[0]);
        Path lib = userDirPath.resolve("lib");
        if (System.getProperty("sun.arch.data.model").equals("32")) {
            try {
                System.load(lib.resolve("mcp2221_dll_um_x86.dll").toString());
                System.load(lib.resolve("libmcp2221_jni_x86.dll").toString());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "The specified library does not exist");
            }
        } else if (System.getProperty("sun.arch.data.model").equals("64")) {
            try {
                System.load(lib.resolve("mcp2221_dll_um_x64.dll").toString());
                System.load(lib.resolve("libmcp2221_jni_x64.dll").toString());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "The specified library does not exist");
            }
        }
    }
}

