/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import unified.bootloader16bit.phy.Bitrate;
import unified.bootloader16bit.phy.lin.ChecksumType;
import unified.bootloader16bit.phy.lin.FrameFormatId;
import unified.bootloader16bit.phy.lin.Model;
import unified.bootloader16bit.phy.lin.Pid;

class Controller
implements Initializable {
    @FXML
    public ComboBox<String> comboLINModule;
    @FXML
    public Button buttonRefresh;
    @FXML
    public ComboBox<Bitrate> comboLinBitRate;
    @FXML
    public ComboBox<String> comboChecksum;
    @FXML
    public TextField textDevicePublisherID;
    @FXML
    public TextField textDeviceSubscriberID;
    @FXML
    public TextField textDeviceNodeAddress;
    @FXML
    public TextField textDeviceServiceId;
    @FXML
    public Label labelProtectedCommand;
    @FXML
    public Label labelProtectedResponse;
    @FXML
    public Button settingUpdate;
    private final Stage dialogStage;
    private final Model model;
    private SimpleObjectProperty<ObservableList<String>> comboLINModuleItems;
    private static final FrameFormatId PID_FORMAT_CHECKER = new FrameFormatId(0, 63);
    private static final FrameFormatId NODE_ID_FORMAT_CHECKER = new FrameFormatId(1, 255);
    private static final FrameFormatId SERVICE_ID_FORMAT_CHECKER = new FrameFormatId(0, 255);

    Controller(Stage stage, Model model) {
        this.dialogStage = stage;
        this.model = model;
    }

    @FXML
    public void actionApplySettings(ActionEvent actionEvent) {
        this.model.setPublisherId(this.textDevicePublisherID.getText());
        this.model.setSubscriberId(this.textDeviceSubscriberID.getText());
        this.model.setNodeId(this.textDeviceNodeAddress.getText());
        this.model.setServiceId(this.textDeviceServiceId.getText());
        this.model.setChecksumType("Classic".equals(this.comboChecksum.getValue()) ? ChecksumType.CLASSIC : ChecksumType.ENHANCED);
        this.model.setDataBitRate(((Bitrate)this.comboLinBitRate.getSelectionModel().getSelectedItem()).getRate());
        this.model.setPort((String)this.comboLINModule.getSelectionModel().getSelectedItem());
        this.dialogStage.close();
    }

    @FXML
    public void actionRefreshAnalyzerList(ActionEvent actionEvent) {
        ((ObservableList)this.comboLINModuleItems.get()).clear();
        ((ObservableList)this.comboLINModuleItems.get()).setAll(this.model.getPorts());
        this.comboLINModule.getSelectionModel().select((Object)this.model.getPort());
    }

    public void initialize(URL location, ResourceBundle resources) {
        SimpleObjectProperty dataBitRateTimes = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        dataBitRateTimes.bind((ObservableValue)this.comboLinBitRate.itemsProperty());
        ((ObservableList)dataBitRateTimes.get()).setAll(Controller.getDataBitRateOptions());
        this.comboLinBitRate.getSelectionModel().select(Controller.indexOfBitRate(Controller.getDataBitRateOptions(), this.model.getDataBitRate()));
        SimpleObjectProperty checksumTypes = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        checksumTypes.bind((ObservableValue)this.comboChecksum.itemsProperty());
        ((ObservableList)checksumTypes.get()).setAll(Controller.getChecksumOptions());
        this.comboChecksum.getSelectionModel().select((Object)Controller.getChecksumOptions().get(this.model.getChecksumIndex()));
        this.comboLINModuleItems = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.comboLINModuleItems.bind((ObservableValue)this.comboLINModule.itemsProperty());
        ((ObservableList)this.comboLINModuleItems.get()).setAll(this.model.getPorts());
        this.comboLINModule.getSelectionModel().select((Object)this.model.getPort());
        this.textDevicePublisherID.setText(this.model.getPublisherId());
        this.textDeviceSubscriberID.setText(this.model.getSubscriberId());
        this.textDeviceNodeAddress.setText(this.model.getNodeId());
        this.textDeviceServiceId.setText(this.model.getServiceId());
        this.textDevicePublisherID.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.textDevicePublisherID.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(PID_FORMAT_CHECKER, this.textDevicePublisherID));
        this.textDeviceSubscriberID.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.textDeviceSubscriberID.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(PID_FORMAT_CHECKER, this.textDeviceSubscriberID));
        this.textDeviceNodeAddress.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.textDeviceNodeAddress.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(NODE_ID_FORMAT_CHECKER, this.textDeviceNodeAddress));
        this.textDeviceServiceId.textProperty().addListener((observable, oldValue, newValue) -> this.validateFields());
        this.textDeviceServiceId.focusedProperty().addListener((observable, oldValue, newValue) -> this.setHexPrefix(SERVICE_ID_FORMAT_CHECKER, this.textDeviceServiceId));
        this.validateFields();
    }

    private void updatePidField(TextField idField, Label protectedIdLabel) {
        Optional<Integer> frameId;
        String protectedIdString = "0x??";
        if (this.valididateHexField(PID_FORMAT_CHECKER, idField) && (frameId = PID_FORMAT_CHECKER.getId(idField.getText())).isPresent()) {
            protectedIdString = Controller.toHexStringByte(Pid.get(frameId.get().byteValue()));
        }
        protectedIdLabel.setText(protectedIdString);
    }

    private void setHexPrefix(FrameFormatId fieldChecker, TextField textField) {
        if (!textField.isFocused() && !((String)textField.textProperty().get()).startsWith("0x") && fieldChecker.isNumber((String)textField.textProperty().get())) {
            textField.textProperty().set((Object)("0x" + (String)textField.textProperty().get()));
        }
    }

    private boolean valididateHexField(FrameFormatId fieldChecker, TextField textField) {
        boolean isValid = fieldChecker.isValidString(textField.getText());
        if (isValid) {
            textField.setStyle("-fx-control-inner-background: white");
        } else {
            textField.setStyle("-fx-control-inner-background: lightpink");
        }
        return isValid;
    }

    private void validateFields() {
        boolean allowUpdate = true;
        allowUpdate &= this.valididateHexField(PID_FORMAT_CHECKER, this.textDevicePublisherID);
        this.updatePidField(this.textDevicePublisherID, this.labelProtectedCommand);
        allowUpdate &= this.valididateHexField(PID_FORMAT_CHECKER, this.textDeviceSubscriberID);
        this.updatePidField(this.textDeviceSubscriberID, this.labelProtectedResponse);
        allowUpdate &= this.valididateHexField(NODE_ID_FORMAT_CHECKER, this.textDeviceNodeAddress);
        this.settingUpdate.disableProperty().set(!(allowUpdate &= this.valididateHexField(SERVICE_ID_FORMAT_CHECKER, this.textDeviceServiceId)));
    }

    static int indexOfBitRate(List<Bitrate> list, int bitrate) {
        if (list == null) {
            return -1;
        }
        return list.indexOf(new Bitrate(bitrate));
    }

    static List<Bitrate> getDataBitRateOptions() {
        ArrayList<Bitrate> list = new ArrayList<Bitrate>();
        list.add(new Bitrate(2400));
        list.add(new Bitrate(4800));
        list.add(new Bitrate(9600));
        list.add(new Bitrate(14400));
        list.add(new Bitrate(19200));
        return list;
    }

    static List<String> getChecksumOptions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Classic");
        list.add("Enhanced");
        return list;
    }

    static String toHexStringByte(byte data) {
        return "0x" + String.format("%02X", data).toUpperCase();
    }
}

