/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.util.Arrays;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.InvalidPduException;

interface Pdu {
    public static final int LENGTH = 8;
    public static final int SID_LENGTH = 1;

    public byte[] get();

    public byte getNodeAddress();

    public Type getType();

    public byte[] getData();

    public Optional<Integer> getLength();

    public Optional<Byte> getServiceId();

    public Optional<Integer> getSequenceNumber();

    public static byte getNodeAddress(byte[] frame) throws InvalidPduException {
        if (frame == null) {
            throw new InvalidPduException("null frame provided");
        }
        if (frame.length < 8) {
            throw new InvalidPduException("Invalid frame length: " + frame.length);
        }
        return frame[0];
    }

    public static enum Type {
        SINGLE_FRAME(0),
        FIRST_FRAME(1),
        CONSECUTIVE_FRAME(2),
        INVALID_FRAME(-1);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        private int getCode() {
            return this.code;
        }

        public static Type get(byte[] frame) {
            return Arrays.asList(Type.values()).stream().filter(type -> type.getCode() == frame[1] >> 4).findFirst().orElse(INVALID_FRAME);
        }
    }
}

