/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import unified.bootloader16bit.phy.lin.ChecksumType;
import unified.bootloader16bit.phy.lin.FrameTransceiver;
import unified.bootloader16bit.phy.lin.Message;
import unified.bootloader16bit.phy.lin.Pdu;
import unified.bootloader16bit.phy.lin.RequestSegmenter;
import unified.bootloader16bit.phy.lin.ResponseAssembler;

public class TransportProtocol {
    private final FrameTransceiver transceiver;
    private final byte requestFrameId;
    private final byte responseFrameId;
    private static final byte REQUEST_DIAGNOSTIC_FRAME_ID = 60;
    private static final byte RESPONSE_DIAGNOSTIC_FRAME_ID = 61;
    private static final int TIMEOUT_N_CR = 1000;
    private static final int TIMEOUT_N_AS = 1000;

    public TransportProtocol(FrameTransceiver transceiver) {
        this(transceiver, 60, 61);
    }

    public TransportProtocol(FrameTransceiver transceiver, byte requestFrameId, byte responseFrameId) {
        this.transceiver = Objects.requireNonNull(transceiver);
        this.requestFrameId = requestFrameId;
        this.responseFrameId = responseFrameId;
    }

    private boolean sendPdu(Pdu pdu, ChecksumType checksumType) {
        Instant start = Instant.now();
        while (Duration.between(start, Instant.now()).toMillis() < 1000L) {
            if (!this.transceiver.write(this.requestFrameId, pdu.get(), checksumType)) continue;
            return true;
        }
        return false;
    }

    public boolean sendRequest(Message message) {
        return this.sendRequest(message, ChecksumType.CLASSIC);
    }

    public boolean sendRequest(Message message, ChecksumType checksumType) {
        List<Pdu> pdus = RequestSegmenter.generatePdus(message);
        return pdus.stream().allMatch(pdu -> this.sendPdu((Pdu)pdu, checksumType));
    }

    public Optional<Message> getResponse() {
        return this.getResponse(ChecksumType.CLASSIC);
    }

    public Optional<Message> getResponse(ChecksumType checksumType) {
        ResponseAssembler messageAssembler = new ResponseAssembler();
        Instant lastRxFrame = Instant.now();
        while (Duration.between(lastRxFrame, Instant.now()).toMillis() < 1000L) {
            Optional<Message> message;
            Optional<byte[]> frame = this.transceiver.read(this.responseFrameId, checksumType);
            if (frame.isPresent()) {
                messageAssembler.addFrame(frame.get());
                lastRxFrame = Instant.now();
            }
            if (!(message = messageAssembler.getMessage()).isPresent()) continue;
            return message;
        }
        return Optional.empty();
    }
}

