/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import console16bit.Console16bit;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import unified.bootloader16bit.phy.lin.Message;
import unified.bootloader16bit.phy.lin.TransportProtocol;
import unified.bootloader16bit.phy.lin.plin.PLinFrameTransceiver;

public class LibMain {
    private static final Logger LOGGER = Logger.getLogger(LibMain.class.getName());

    public static void main(String[] args) throws InterruptedException {
        LibMain libMain = new LibMain();
        libMain.run();
    }

    private void run() throws InterruptedException {
        this.transportProtocolIntegerationTest();
    }

    private void transportProtocolIntegerationTest() throws InterruptedException {
        MyConsole16 console = new MyConsole16();
        PLinFrameTransceiver lin = new PLinFrameTransceiver(console);
        byte[] getVersionCommand = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int nodeAddress = 3;
        int serviceId = -55;
        int requestFrameId = 5;
        int responseFrameId = 6;
        lin.open(lin.getIds().get(0), 9600);
        TransportProtocol transport = new TransportProtocol(lin, 5, 6);
        Message message = new Message(3, -55, getVersionCommand);
        boolean status = transport.sendRequest(message);
        LOGGER.log(Level.INFO, "Request status: {0}", status);
        Thread.sleep(200L);
        Optional<Message> response = transport.getResponse();
        if (response.isPresent()) {
            LOGGER.log(Level.INFO, "Response received: {0}", Arrays.toString(response.get().getData()));
            this.printReadVersionInfo(response.get().getData());
        } else {
            LOGGER.log(Level.INFO, "No response.");
        }
        lin.close();
    }

    private void printReadVersionInfo(byte[] responseArray) {
        ByteBuffer response = ByteBuffer.wrap(responseArray);
        response.order(ByteOrder.LITTLE_ENDIAN);
        byte command = response.get();
        short length = response.getShort();
        int unlock = response.getInt();
        int address = response.getInt();
        short bootVersion = response.getShort();
        short maxPacketSize = response.getShort();
        response.getShort();
        short deviceId = response.getShort();
        response.getShort();
        short erasePage = response.getShort();
        short minWriteSize = response.getShort();
        LOGGER.log(Level.INFO, "Command: {0}", LibMain.toHexString(command));
        LOGGER.log(Level.INFO, "Length: {0}", LibMain.toHexString(length));
        LOGGER.log(Level.INFO, "Unlock: {0}", LibMain.toHexString(unlock));
        LOGGER.log(Level.INFO, "Address: {0}", LibMain.toHexString(address));
        LOGGER.log(Level.INFO, "Boot version: {0}", LibMain.toHexString(bootVersion));
        LOGGER.log(Level.INFO, "Max Packet Size: {0}", LibMain.toHexString(maxPacketSize));
        LOGGER.log(Level.INFO, "Device id: {0}", LibMain.toHexString(deviceId));
        LOGGER.log(Level.INFO, "Erase page size: {0}", LibMain.toHexString(erasePage));
        LOGGER.log(Level.INFO, "Minimum write size: {0}", LibMain.toHexString(minWriteSize));
    }

    static String toHexString(int value) {
        return "0x" + Long.toHexString(value).toUpperCase();
    }

    class MyConsole16
    implements Console16bit {
        MyConsole16() {
        }

        @Override
        public void addConsoleText(Level level, String consoleText) {
            LOGGER.log(Level.INFO, "{0}: {1}", new Object[]{level, consoleText});
        }

        @Override
        public void addConsoleText(Level level, ArrayList<String> consoleText) {
            consoleText.forEach(text -> this.addConsoleText(level, (String)text));
        }

        @Override
        public void addConsoleText(String consoleText) {
            this.addConsoleText(Level.INFO, consoleText);
        }

        @Override
        public void addConsoleText(ArrayList<String> consoleText) {
            consoleText.forEach(this::addConsoleText);
        }

        @Override
        public void displayConsole() {
            LOGGER.log(Level.INFO, "Console Displayed");
        }
    }
}

