/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINDirection {
    DISABLED(0),
    PUBLISHER(1),
    SUBSCRIBER(2),
    SUBSCRIBER_AUTO_LENGTH(3),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINDirection(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TLINDirection get(int code) {
        TLINDirection directionReturn = Arrays.asList(TLINDirection.values()).stream().filter(direction -> direction.getCode() == code).findFirst().orElse(INVALID_CODE);
        if (directionReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid Direction code provided: {0}", code);
        }
        return directionReturn;
    }

    static {
        logger = Logger.getLogger(TLINDirection.class.getName());
    }
}

