/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.lin.plin;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TLINError {
    ERR_OK(0),
    ERR_XMT_QUEUE_FULL(1),
    ERR_ILLEGAL_PERIOD(2),
    ERR_RCV_QUEUE_EMPTY(3),
    ERR_ILLEGAL_CHECKSUM_TYPE(4),
    ERR_ILLEGAL_HARDWARE(5),
    ERR_ILLEGAL_CLIENT(6),
    ERR_WRONG_PARAMETER_TYPE(7),
    ERR_WRONG_PARAMETER_VALUE(8),
    ERR_ILLEGAL_DIRECTION(9),
    ERR_ILLEGAL_LENGTH(10),
    ERR_ILLEGAL_BAUDRATE(11),
    ERR_ILLEGAL_FRAME_ID(12),
    ERR_BUFFER_INSUFFICIENT(13),
    ERR_ILLEGAL_SCHEDULE_NO(14),
    ERR_ILLEGAL_SLOT_COUNT(15),
    ERR_ILLEGAL_INDEX(16),
    ERR_ILLEGAL_RANGE(17),
    ERR_ILLEGAL_HARDWARE_STATE(18),
    ERR_ILLEGAL_SCHEDULER_STATE(19),
    ERR_ILLEGAL_FRAME_CONFIGURATION(20),
    ERR_SCHEDULE_SLOT_POOL_FULL(21),
    ERR_ILLEGAL_SCHEDULE(22),
    ERR_ILLEGAL_HARDWARE_MODE(23),
    ERR_OUT_OF_RESOURCE(1001),
    ERR_MANAGER_NOT_LOADED(1002),
    ERR_MANAGER_NOT_RESPONDING(1003),
    ERR_MEMORY_ACCESS(1004),
    ERR_NOT_IMPLEMENTED(65534),
    ERR_UNKNOWN(65535),
    INVALID_CODE(-1);

    private static final Logger logger;
    private final int code;

    private TLINError(int code) {
        this.code = code;
    }

    public static TLINError get(int code) {
        TLINError errorReturn = Arrays.asList(TLINError.values()).stream().filter(error -> error.code == code).findFirst().orElse(INVALID_CODE);
        if (errorReturn.equals((Object)INVALID_CODE)) {
            logger.log(Level.SEVERE, "Invalid TLINError code provided: {0}", code);
        }
        return errorReturn;
    }

    static {
        logger = Logger.getLogger(TLINError.class.getName());
    }
}

