/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader16bit.phy.uart;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import unified.bootloader16bit.phy.uart.Model;

public class Controller
implements Initializable {
    @FXML
    public ComboBox<Integer> comboBaud;
    @FXML
    public ComboBox<String> comboDataBits;
    @FXML
    public ComboBox<String> comboStopBits;
    @FXML
    public ComboBox<String> comboParity;
    @FXML
    public Button settingUpdate;
    @FXML
    public Label labelComPort;
    @FXML
    public Button buttonRefresh;
    @FXML
    public ComboBox<String> comboComPort;
    private final Stage dialogStage;
    private final Model model;
    private SimpleObjectProperty<ObservableList<Integer>> comboBaudTimes;
    private SimpleObjectProperty<ObservableList<String>> comboComPortItems;
    private ChangeListener<String> comboComPortCL;
    private ChangeListener<Integer> comboBaudCL;

    Controller(Stage stage, Model model) {
        this.dialogStage = stage;
        this.model = model;
        this.comboComPortCL = (observable, oldValue, newValue) -> model.setPort((String)newValue);
        this.comboBaudCL = (observable, oldValue, newValue) -> model.setBaudRate((Integer)newValue);
    }

    @FXML
    public void actionApplySettings(ActionEvent actionEvent) {
        this.dialogStage.close();
    }

    @FXML
    public void actionRefreshComList(ActionEvent actionEvent) {
        this.removeListeners();
        ((ObservableList)this.comboComPortItems.get()).setAll(this.model.getPorts());
        this.comboComPort.getSelectionModel().select((Object)this.model.getPort());
        this.addListeners();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.renderRefreshButton();
        this.renderComboParity();
        this.renderComboStopBits();
        this.renderComboDataBits();
        this.comboComPortItems = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.comboComPortItems.bind((ObservableValue)this.comboComPort.itemsProperty());
        ((ObservableList)this.comboComPortItems.get()).setAll(this.model.getPorts());
        this.comboComPort.getSelectionModel().select((Object)this.model.getPort());
        this.comboBaudTimes = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        this.comboBaudTimes.bind((ObservableValue)this.comboBaud.itemsProperty());
        ((ObservableList)this.comboBaudTimes.get()).setAll(this.getIntegers());
        this.comboBaud.getSelectionModel().select((Object)this.model.getBaudRate());
        this.addListeners();
    }

    private void addListeners() {
        this.comboComPort.getSelectionModel().selectedItemProperty().addListener(this.comboComPortCL);
        this.comboBaud.getSelectionModel().selectedItemProperty().addListener(this.comboBaudCL);
    }

    private void removeListeners() {
        this.comboComPort.getSelectionModel().selectedItemProperty().removeListener(this.comboComPortCL);
        this.comboBaud.getSelectionModel().selectedItemProperty().removeListener(this.comboBaudCL);
    }

    private void renderComboParity() {
        this.comboParity.getItems().clear();
        this.comboParity.getItems().add((Object)"Disabled");
        this.comboParity.getSelectionModel().select(0);
        this.comboParity.setDisable(true);
    }

    private void renderComboStopBits() {
        this.comboStopBits.getItems().clear();
        this.comboStopBits.getItems().add((Object)"1");
        this.comboStopBits.getSelectionModel().select(0);
        this.comboStopBits.setDisable(true);
    }

    private void renderComboDataBits() {
        this.comboDataBits.getItems().clear();
        this.comboDataBits.getItems().add((Object)"8");
        this.comboDataBits.getSelectionModel().select(0);
        this.comboDataBits.setDisable(true);
    }

    private void renderRefreshButton() {
        Image imageRefresh = new Image(this.getClass().getResourceAsStream("/portSettings/refreshIcon.png"));
        ImageView imageButtonRefresh = new ImageView();
        imageButtonRefresh.setImage(imageRefresh);
        imageButtonRefresh.setFitWidth(20.0);
        imageButtonRefresh.setPreserveRatio(true);
        imageButtonRefresh.setSmooth(true);
        imageButtonRefresh.setCache(true);
        this.buttonRefresh.setGraphic((Node)imageButtonRefresh);
    }

    private List<Integer> getIntegers() {
        ArrayList<Integer> rates = new ArrayList<Integer>();
        rates.add(1200);
        rates.add(2400);
        rates.add(4800);
        rates.add(9600);
        rates.add(19200);
        rates.add(38400);
        rates.add(57600);
        rates.add(115200);
        rates.add(230400);
        rates.add(460800);
        return rates;
    }
}

