/*
 * Decompiled with CFR 0.152.
 */
package unified.bootloader8bit;

import I2CSettings.I2CSettings;
import com.microchip.core.util.HexOnlyValidator;
import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import commands.BootloadDFUFED;
import commands.BootloadI2CDFUFED;
import commands.ICommand;
import console.Console;
import i2cReadWriteStopXferFunctions.MCPUSBI2CBridgeAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import observers.ALoraObserver;
import portSettings.PortSettings;
import toplevel.JavaFXTextFieldChangeListener;
import uartjsscadapter.JSSCSerialPortAdapter;
import unified.MVController.MVController;
import unified.bootloader.model.IDeviceModel;
import unified.bootloader.model.UBootModel;
import unified.bootloader8bit.UBoot;
import usbhid4javaserviceprovider.Hid4JavaUSBAdapter;

public class UBootFXMLController
implements Initializable {
    UBoot application;
    JSSCSerialPortAdapter jsscDriverInterface = new JSSCSerialPortAdapter();
    Hid4JavaUSBAdapter usbDriverInterface = new Hid4JavaUSBAdapter();
    CommunicationsInterface commsInterface;
    I2CSoftwareLibraryCommunicationsInterface i2cInterface = new MCPUSBI2CBridgeAdapter();
    private static final Logger LOGGER = Logger.getLogger(UBootFXMLController.class.getName());
    @FXML
    private ComboBox<String> deviceList;
    @FXML
    private ComboBox<String> comboProtocol;
    private final String stringUART = "UART";
    private final String stringI2C = "I2C";
    @FXML
    private Label labelConfigStatus;
    @FXML
    private ProgressBar progress;
    @FXML
    private TextField programMemorySize;
    @FXML
    private TextField bootloaderOffset;
    @FXML
    private TextField eepromOffset;
    @FXML
    private TextField eepromMemorySize;
    @FXML
    private TextField configOffset;
    @FXML
    private TextField configMemorySize;
    @FXML
    private Label labelStatusResult;
    @FXML
    private CheckBox configWordsProgramOption;
    @FXML
    private CheckBox eedataPorgramOption;
    FileChooser fileOpenDialog = new FileChooser();
    Map<TextField, JavaFXTextFieldChangeListener<UBootModel>> changeListener = new HashMap<TextField, JavaFXTextFieldChangeListener<UBootModel>>();
    Console console = null;
    int progressMax = 100;
    int progressCurrent = 1;
    private final String stringNotConfigured = "Not Configured";
    private final String stringReady = "Ready";
    private final String stringConnected = "Device Connected Successfully";
    private final String stringNoConnection = "No Current Device Connection";
    private static final int SERIAL_TIMEOUT = 20000;
    private static final int USB_TIMEOUT = 50000;

    public UBootFXMLController(UBoot application) {
        this.application = application;
    }

    public void initialize(URL url, ResourceBundle rb) {
        LOGGER.addHandler(new StreamHandler(System.out, new SimpleFormatter()));
        this.jsscDriverInterface.setTimeOut(20000);
        this.usbDriverInterface.setTimeOut(50000);
        this.application.device.ubootPojo.setProtocolType("UART");
        this.labelStatusResult.setText("Communication Method: UART");
        this.labelConfigStatus.setText("Not Configured");
        this.comboProtocol.getItems().add((Object)"UART");
        this.comboProtocol.getItems().add((Object)"I2C");
        this.comboProtocol.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    UBootFXMLController.this.labelStatusResult.setText("No Current Device Connection");
                    UBootFXMLController.this.labelConfigStatus.setText("Not Configured");
                    UBootFXMLController.this.application.device.ubootPojo.setProtocolType(newValue);
                    LOGGER.log(Level.FINE, String.format(UBootFXMLController.this.application.device.ubootPojo.getProtocolType().get() + " Protocol Selected", new Object[0]));
                }
            }
        });
        this.comboProtocol.getSelectionModel().select((Object)"UART");
        this.progress.setProgress(0.0);
        this.application.getModel().ubootPojo.getConfigurationChangedState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootFXMLController.this.application.getModel().ubootPojo.getConfigurationChangedState().getValue().booleanValue()) {
                    UBootFXMLController.this.configureSettings();
                }
            }
        });
        this.application.getModel().ubootPojo.getConsoleState().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (UBootFXMLController.this.application.getModel().ubootPojo.getConsoleState().getValue().booleanValue()) {
                    UBootFXMLController.this.showConsole();
                }
            }
        });
        JavaFXTextFieldChangeListener<UBootModel> listener = new JavaFXTextFieldChangeListener<UBootModel>(this.bootloaderOffset, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setBootloaderOffset(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validator = new HexOnlyValidator();
        listener.setValidator(validator);
        this.changeListener.put(this.bootloaderOffset, listener);
        this.bootloaderOffset.textProperty().addListener((ChangeListener)listener);
        JavaFXTextFieldChangeListener<UBootModel> listenerPMS = new JavaFXTextFieldChangeListener<UBootModel>(this.programMemorySize, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setProgramMemorySize(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validatorPMS = new HexOnlyValidator();
        listenerPMS.setValidator(validatorPMS);
        this.changeListener.put(this.programMemorySize, listenerPMS);
        this.programMemorySize.textProperty().addListener((ChangeListener)listenerPMS);
        JavaFXTextFieldChangeListener<UBootModel> listenerEO = new JavaFXTextFieldChangeListener<UBootModel>(this.eepromOffset, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setByteAlignedeepromMemoryOffset(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validatorEO = new HexOnlyValidator();
        listenerEO.setValidator(validatorEO);
        this.changeListener.put(this.eepromOffset, listenerEO);
        this.eepromOffset.textProperty().addListener((ChangeListener)listenerEO);
        JavaFXTextFieldChangeListener<UBootModel> listenerES = new JavaFXTextFieldChangeListener<UBootModel>(this.eepromMemorySize, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setSetbyteAlignedeepromSize(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validatorES = new HexOnlyValidator();
        listenerES.setValidator(validatorES);
        this.changeListener.put(this.eepromMemorySize, listenerES);
        this.eepromMemorySize.textProperty().addListener((ChangeListener)listenerES);
        JavaFXTextFieldChangeListener<UBootModel> listenerCMO = new JavaFXTextFieldChangeListener<UBootModel>(this.configOffset, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setByteAlignedConfigMemoryOffset(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validatorCMO = new HexOnlyValidator();
        listenerCMO.setValidator(validatorCMO);
        this.changeListener.put(this.configOffset, listenerCMO);
        this.configOffset.textProperty().addListener((ChangeListener)listenerCMO);
        JavaFXTextFieldChangeListener<UBootModel> listenerCMS = new JavaFXTextFieldChangeListener<UBootModel>(this.configMemorySize, this.application.device){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    String validatedValue = this.validator.validate(newValue);
                    if (validatedValue != null) {
                        this.animation.stop();
                        this.textField.setStyle("-fx-text-inner-color: blue; -fx-border-color: blue; -fx-opacity: 1.0");
                        if (((UBootModel)this.device).updateValueFlag) {
                            ((UBootModel)this.device).ubootPojo.setSetbyteAlignedConfigSize(validatedValue);
                        }
                    } else {
                        this.textField.setStyle("-fx-text-inner-color: red; -fx-border-color: red; -fx-background-color: lightpink");
                        this.animation.playFromStart();
                    }
                }
            }
        };
        HexOnlyValidator validatorCMS = new HexOnlyValidator();
        listenerCMS.setValidator(validatorCMS);
        this.changeListener.put(this.configMemorySize, listenerCMS);
        this.configMemorySize.textProperty().addListener((ChangeListener)listenerCMS);
        this.eedataPorgramOption.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != null) {
                    if (newValue.booleanValue()) {
                        UBootFXMLController.this.application.device.ubootPojo.setProgramEEData("Enabled");
                    } else {
                        UBootFXMLController.this.application.device.ubootPojo.setProgramEEData("Disabled");
                    }
                }
            }
        });
        this.configWordsProgramOption.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != null) {
                    if (newValue.booleanValue()) {
                        UBootFXMLController.this.application.device.ubootPojo.setProgramConfigurationWords("Enabled");
                    } else {
                        UBootFXMLController.this.application.device.ubootPojo.setProgramConfigurationWords("Disabled");
                    }
                }
            }
        });
        this.console = Console.getConsole(this.application);
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootModel>(){

            @Override
            public void handleEvent(UBootModel value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Property") == 0 && !UBootFXMLController.this.labelConfigStatus.getText().equals("Not Configured")) {
                            UBootFXMLController.this.labelStatusResult.setText("Device Connected Successfully");
                        }
                    }
                });
            }
        });
        this.application.device.addPropertyChangeListener(new ALoraObserver<UBootModel>(){

            @Override
            public void handleEvent(UBootModel value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("WriteBlockSize") == 0) {
                            UBootFXMLController.this.progressMax = (Integer.parseInt(UBootFXMLController.this.application.getModel().ubootPojo.getProgramMemorySize().replace("0x", ""), 16) - Integer.parseInt(UBootFXMLController.this.application.getModel().ubootPojo.getBootloaderOffset().replace("0x", ""), 16)) / Integer.parseInt(UBootFXMLController.this.application.getModel().ubootPojo.getWriteBlockSize().replace("0x", ""), 16);
                        }
                    }
                });
            }
        });
        this.application.device.addConsolePropertyChangeListener(new ALoraObserver<UBootModel>(){

            @Override
            public void handleEvent(UBootModel value, final String whatChanged) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (whatChanged.compareTo("Progress") == 0) {
                            UBootFXMLController.this.progress.setProgress((double)UBootFXMLController.this.progressCurrent / (double)UBootFXMLController.this.progressMax);
                            ++UBootFXMLController.this.progressCurrent;
                        }
                    }
                });
            }
        });
        this.application.getModel().i2cPojo.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootFXMLController.this.configureLabelUpdate();
            }
        });
        this.application.getModel().dfuPojo.getConfigured().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UBootFXMLController.this.configureLabelUpdate();
            }
        });
        this.deviceList.getItems().add((Object)"PIC16");
        this.deviceList.getItems().add((Object)"PIC18");
        this.deviceList.getSelectionModel().clearSelection();
        this.deviceList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    UBootFXMLController.this.application.device.ubootPojo.setDeviceArchitecture(newValue);
                    LOGGER.log(Level.FINE, String.format(UBootFXMLController.this.application.device.ubootPojo.getDeviceArchitecture(), new Object[0]));
                    UBootFXMLController.this.architectureDefaults();
                }
            }
        });
        this.deviceList.getSelectionModel().selectFirst();
    }

    private void architectureDefaults() {
        if (((String)this.deviceList.getValue()).contains("PIC16")) {
            this.bootloaderOffset.setText("0x600");
            this.programMemorySize.setText("0x4000");
            this.eepromOffset.setText("0x1E000");
            this.eepromMemorySize.setText("0x40");
            this.configOffset.setText("0x10000");
            this.configMemorySize.setText("0x0E");
        } else if (((String)this.deviceList.getValue()).contains("PIC18")) {
            this.bootloaderOffset.setText("0x300");
            this.programMemorySize.setText("0x4000");
            this.eepromOffset.setText("0xF00000");
            this.eepromMemorySize.setText("0x100");
            this.configOffset.setText("0x300000");
            this.configMemorySize.setText("0x0E");
        } else {
            this.bootloaderOffset.setText("0x00");
            this.programMemorySize.setText("0x00");
            this.eepromOffset.setText("0x00");
            this.eepromMemorySize.setText("0x00");
            this.configOffset.setText("0x00");
            this.configMemorySize.setText("0x00");
        }
    }

    private void configureSettings() {
        String currentProtocol = (String)this.comboProtocol.getValue();
        if (currentProtocol.contains("UART")) {
            this.application.device.dfuPojo.setConfigured(false);
            this.configureComSettings();
        } else if (currentProtocol.contains("I2C")) {
            this.application.device.i2cPojo.setConfigured(false);
            this.configureI2CSettings();
        }
        this.application.getModel().ubootPojo.setConfigurationChangedState(false);
    }

    private void configureComSettings() {
        this.commsInterface = this.jsscDriverInterface;
        PortSettings setting = new PortSettings(this.application);
        try {
            this.application.device.dfuPojo.getComList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.dfuPojo.getComList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to configure COM Settings. " + ex.toString(), ex);
        }
    }

    private void configureI2CSettings() {
        this.commsInterface = this.usbDriverInterface;
        this.i2cInterface.aetLowerLevelCommunicationsInterface(this.commsInterface);
        I2CSettings setting = new I2CSettings(this.application);
        try {
            this.application.device.i2cPojo.getDeviceList().clear();
            String[] returnedListAvailable = this.commsInterface.getAttachedDevices();
            this.application.device.i2cPojo.getDeviceList().addAll(Arrays.asList(returnedListAvailable));
            setting.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to configure I2C Settings. " + ex.toString(), ex);
        }
    }

    void configureLabelUpdate() {
        String protocol = this.application.device.ubootPojo.getProtocolType().get();
        if (protocol.contains("UART")) {
            try {
                this.commsInterface = this.jsscDriverInterface;
                this.commsInterface.setDeviceName(this.application.device.dfuPojo.getComPort());
                this.commsInterface.connect();
                this.jsscDriverInterface.setDeviceName(this.application.device.dfuPojo.getComPort());
                this.jsscDriverInterface.baudRate = Integer.parseInt(this.application.device.dfuPojo.getBaudRate());
                this.jsscDriverInterface.dataBits = Integer.parseInt(this.application.device.dfuPojo.getDataBits());
                this.jsscDriverInterface.stopBits = Integer.parseInt(this.application.device.dfuPojo.getStopBits());
                String readParity = this.application.device.dfuPojo.getParity();
                if (readParity.contains("Enabled")) {
                    this.jsscDriverInterface.setParity(true);
                } else {
                    this.jsscDriverInterface.setParity(false);
                }
                this.commsInterface.disconnect();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Failed to be able to connect to Serial Interface." + ex.toString(), ex);
            }
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append(this.jsscDriverInterface.getDeviceName());
            statusLabel.append(" @ ");
            statusLabel.append(this.jsscDriverInterface.getBaudRate());
            statusLabel.append(" DB: ");
            statusLabel.append(this.jsscDriverInterface.getStartBits());
            statusLabel.append(" SB: ");
            statusLabel.append(this.jsscDriverInterface.getStopBits());
            statusLabel.append(" Parity: ");
            statusLabel.append(this.jsscDriverInterface.getParity());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else if (protocol.contains("I2C")) {
            StringBuilder statusLabel = new StringBuilder();
            statusLabel.append("Device w PID: ");
            statusLabel.append(this.application.device.i2cPojo.getDeviceSelected());
            statusLabel.append(" BitRate: ");
            statusLabel.append(this.application.device.i2cPojo.getDeviceBitRate());
            statusLabel.append("(Kbits/s) @ Address: ");
            statusLabel.append(this.application.device.i2cPojo.getDeviceAddress());
            this.labelConfigStatus.setText(statusLabel.toString());
        } else {
            this.labelStatusResult.setText("Error Has Occured. Configuration Bad");
        }
    }

    @FXML
    void programDevice(ActionEvent event) {
        String protocol = this.application.device.ubootPojo.getProtocolType().get();
        String name = this.application.device.ubootPojo.getFileName();
        if (name == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error Dialog");
            alert.setHeaderText("Hex File Selection");
            alert.setContentText("HEX file not selected. Could not start programming the device.\nPlease choose a .hex file from the File Menu Dialog.");
            alert.showAndWait();
            return;
        }
        this.labelStatusResult.setText("Attempting Bootloader Command Chain Example.");
        if (protocol.contains("UART")) {
            this.programSerial();
        } else if (protocol.contains("I2C")) {
            this.programI2C();
        }
    }

    public void programSerial() {
        this.ConnectSerial();
        this.progressCurrent = 1;
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadDFUFED bootload = new BootloadDFUFED();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    public void programI2C() {
        this.ConnectI2C();
        this.progressCurrent = 1;
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        BootloadI2CDFUFED bootload = new BootloadI2CDFUFED();
        bootload.setDataModel(this.application.getModel());
        commands.add(bootload);
        this.application.mvcController.execute(commands);
    }

    public void ConnectSerial() {
        this.commsInterface = this.jsscDriverInterface;
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.dfuPojo.getComPort(), new Object[0]));
        try {
            this.commsInterface.connect();
            this.application.startupConnectedDeviceMap.put(this.application.device.dfuPojo.getComPort(), this.jsscDriverInterface);
            this.application.injectController(new MVController());
            this.application.setDeviceName(this.application.device.dfuPojo.getComPort());
            this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
            this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
            this.application.injectModelCommunicationInterface(this.jsscDriverInterface);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Creation Failed. " + ex.toString(), ex);
        }
    }

    public void ConnectI2C() {
        try {
            this.commsInterface.setDeviceName(this.application.device.i2cPojo.getDeviceSelected());
            boolean connectResult = this.commsInterface.connect();
            LOGGER.fine(String.format("connect result: %s", connectResult));
            this.usbDriverInterface.setDeviceName(this.application.device.i2cPojo.getDeviceSelected());
            Integer integerI2CAddress = Integer.parseInt(this.application.device.i2cPojo.getDeviceAddress().replace("0x", ""), 16);
            String stringI2CAddressValue = Integer.toString(integerI2CAddress);
            byte readI2CAddressValue = Byte.valueOf(stringI2CAddressValue);
            LOGGER.fine(String.format("Parsed I2C Address: %s", readI2CAddressValue));
            this.i2cInterface.setI2CAddress(readI2CAddressValue);
            this.i2cInterface.setBitrate(Integer.parseInt(this.application.device.i2cPojo.getDeviceBitRate()));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to be able to connect to I2C Interface.", ex);
        }
        this.commsInterface = this.usbDriverInterface;
        this.i2cInterface.aetLowerLevelCommunicationsInterface(this.commsInterface);
        LOGGER.log(Level.FINE, String.format("Trying to Connect: " + this.application.device.i2cPojo.getDeviceSelected(), new Object[0]));
        this.application.startupConnectedDeviceMap.put(this.application.device.i2cPojo.getDeviceSelected(), this.usbDriverInterface);
        this.application.injectController(new MVController());
        this.application.setDeviceName(this.application.device.i2cPojo.getDeviceSelected());
        this.application.mvcController.afterFailure(new Failure(this.application.getModel()));
        this.application.mvcController.afterSuccess(new Success(this.application.getModel()));
        this.application.injectI2CInterface(this.i2cInterface);
    }

    void handleDisconnect(IDeviceModel dev) {
        this.labelStatusResult.setText("Attempt Completed. Result in Console.");
        LOGGER.log(Level.FINE, String.format("Trying to Disconnect: " + this.application.device.dfuPojo.getComPort(), new Object[0]));
        try {
            this.commsInterface.disconnect();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Device Destruction Failed" + ex.toString(), ex);
        }
    }

    private void showConsole() {
        try {
            this.console.init();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Show Console Failed. " + ex.toString(), ex);
        }
        this.application.getModel().ubootPojo.setConsoleState(false);
    }

    class Success
    implements EventHandler {
        IDeviceModel dev = null;

        public Success(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootFXMLController.this.progress.setProgress(0.0);
            UBootFXMLController.this.handleDisconnect(this.dev);
            LOGGER.log(Level.FINE, "Disconnected after Programming was Successful.");
        }
    }

    class Failure
    implements EventHandler {
        IDeviceModel dev = null;

        public Failure(IDeviceModel dev) {
            this.dev = dev;
        }

        public void handle(Event event) {
            UBootFXMLController.this.progress.setProgress(0.0);
            UBootFXMLController.this.handleDisconnect(this.dev);
            LOGGER.log(Level.SEVERE, "Disconnected after Programming Failed.");
        }
    }
}

