/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.scf.factory;

import com.microchip.scf.services.UARTCommunicationsService;
import com.microchip.scf.services.USBHIDCommunicationsService;
import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import com.microchip.scf.softwarelibraryinterfaces.services.I2CCommunicationsService;
import com.microchip.scf.uart.UARTCommunicationsInterface;
import com.microchip.scf.usb.USBCommunicationsInterface;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommunicationsFactory {
    public static String hidUSB = "HID";
    private static final Logger LOGGER = Logger.getLogger(CommunicationsFactory.class.getName());

    public static UARTCommunicationsInterface getSerialService() throws IOException {
        UARTCommunicationsInterface uartInterface = UARTCommunicationsService.getComm();
        if (uartInterface == null) {
            LOGGER.log(Level.SEVERE, "No UART Service Providers found. Please install one.");
            throw new IOException("No UART Service Providers found. Please install one.");
        }
        return uartInterface;
    }

    public static USBCommunicationsInterface getUSBService(String usbClass) throws IOException {
        if (usbClass.compareTo(hidUSB) == 0) {
            USBCommunicationsInterface usbInterface = USBHIDCommunicationsService.getComm();
            if (usbInterface == null) {
                LOGGER.log(Level.SEVERE, "No USB Service Providers found. Please install one.");
                throw new IOException("No USB Service Providers found. Please install one.");
            }
            return usbInterface;
        }
        LOGGER.log(Level.SEVERE, "USB Class not supported.");
        throw new IOException("USB Class not supported.");
    }

    public static I2CSoftwareLibraryCommunicationsInterface getI2CService() throws IOException {
        I2CSoftwareLibraryCommunicationsInterface i2cInterface = I2CCommunicationsService.getComm();
        if (i2cInterface == null) {
            LOGGER.log(Level.SEVERE, "No I2C Service Providers found. Please install one.");
            throw new IOException("No I2C Service Providers found. Please install one.");
        }
        return i2cInterface;
    }
}

