/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intel_hex;

import com.microchip.helper.Helper;
import com.microchip.intel_hex.HexAddressRange;
import com.microchip.intel_hex.HexException;
import com.microchip.intel_hex.HexRecord;
import com.microchip.intel_hex.HexRecordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HexAddressRangeList {
    private static final Logger LOGGER = Logger.getLogger(HexAddressRangeList.class.getName());

    public static HexAddressRange[] getList(InputStream hexFileInStream) throws IOException, HexException {
        String hexRecordString;
        InputStreamReader inputReader = new InputStreamReader(hexFileInStream);
        BufferedReader bufferReader = new BufferedReader(inputReader);
        LinkedList<HexAddressRange> rangeList = new LinkedList<HexAddressRange>();
        long extendedAddress = 0L;
        long startingAddress = 0L;
        long range = 0L;
        block7: while ((hexRecordString = bufferReader.readLine()) != null) {
            HexRecord hexRecord = new HexRecord(hexRecordString);
            HexRecordType recordType = hexRecord.getRecordType();
            if (recordType == HexRecordType.EOF) {
                if (range <= 0L) break;
                HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
                rangeList.add(addressRange);
                range = 0L;
                break;
            }
            switch (recordType) {
                case DATA: {
                    long addressOffset = (extendedAddress & 0xFFFFFFFFFFFF0000L) + ((long)hexRecord.getAddress() & 0xFFFFL);
                    if (startingAddress + range != addressOffset) {
                        if (range > 0L) {
                            HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
                            rangeList.add(addressRange);
                        }
                        startingAddress = addressOffset;
                        range = hexRecord.getDataLength();
                        continue block7;
                    }
                    range += (long)hexRecord.getDataLength() & 0xFFL;
                    continue block7;
                }
                case EXTENDED_SEG_ADDR: {
                    bufferReader.close();
                    inputReader.close();
                    LOGGER.log(Level.SEVERE, "0x02 Extended Sement Address Not Supported Record Type in intex_hex");
                    LOGGER.log(Level.SEVERE, "Throwing Exception!");
                    throw new HexException("Extended Segmented Address Records are not supported");
                }
                case START_SEGMENT_ADDR: {
                    LOGGER.log(Level.WARNING, "0x03 Start Segment Address is not a supported Record Type in intex_hex");
                    LOGGER.log(Level.WARNING, "Skipping line in Hex file; and continuing Parsing.");
                    continue block7;
                }
                case EXTENDED_LINEAR_ADDR: {
                    extendedAddress = Helper.getShort(hexRecord.getData(), 0, false);
                    extendedAddress &= 0xFFFFL;
                    extendedAddress <<= 16;
                    continue block7;
                }
                case START_LINEAR_ADDR: {
                    LOGGER.log(Level.WARNING, "0x05 Start Segment Address is not a supported Record Type in intex_hex");
                    LOGGER.log(Level.WARNING, "Skipping line in Hex file; and continuing Parsing.");
                    continue block7;
                }
            }
            throw new HexException("Bad intel_hex record type response");
        }
        if (range > 0L) {
            HexAddressRange addressRange = new HexAddressRange(startingAddress, range);
            rangeList.add(addressRange);
        }
        System.gc();
        HexAddressRange[] addressRanges = new HexAddressRange[rangeList.size()];
        for (int i = 0; i < addressRanges.length; ++i) {
            addressRanges[i] = (HexAddressRange)rangeList.remove();
        }
        return addressRanges;
    }

    public static HexAddressRange[] getList(File hexFile) throws IOException, HexException {
        FileInputStream inputStream = new FileInputStream(hexFile);
        HexAddressRange[] hexList = HexAddressRangeList.getList(inputStream);
        inputStream.close();
        return hexList;
    }
}

