/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.intel_hex;

import com.microchip.helper.Helper;
import com.microchip.intel_hex.HexException;
import com.microchip.intel_hex.HexRecord;
import com.microchip.intel_hex.HexRecordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HexFile {
    private FileInputStream inputStream;
    private InputStreamReader inputReader;
    private BufferedReader bufferReader;
    private static final Logger LOGGER = Logger.getLogger(HexFile.class.getName());

    public HexFile(File hexFile) throws IOException {
        this.inputStream = new FileInputStream(hexFile);
        this.inputReader = new InputStreamReader(this.inputStream);
        this.bufferReader = new BufferedReader(this.inputReader);
    }

    public void close() throws IOException {
        this.bufferReader.close();
        this.inputReader.close();
        this.inputStream.close();
    }

    public String getNextRecord() throws IOException {
        return this.bufferReader.readLine();
    }

    public static byte[] getData(InputStream hexInStream, long startingAddress, int range) throws IOException, HexException {
        HexRecord hexRecord;
        HexRecordType recordType;
        String hexRecordString;
        byte[] data = new byte[range];
        InputStreamReader inputReader = new InputStreamReader(hexInStream);
        BufferedReader bufferReader = new BufferedReader(inputReader);
        long endingAddress = startingAddress + (long)range;
        long extendedAddress = 0L;
        int dataIdx = 0;
        block7: while ((hexRecordString = bufferReader.readLine()) != null && (recordType = (hexRecord = new HexRecord(hexRecordString)).getRecordType()) != HexRecordType.EOF && range > 0) {
            switch (recordType) {
                case DATA: {
                    long startingDataAddress = (extendedAddress & 0xFFFFFFFFFFFF0000L) + (long)hexRecord.getAddress();
                    long endingDataAddress = startingDataAddress + (long)hexRecord.getDataLength();
                    int copySize = 0;
                    int recordDataIdx = 0;
                    if (startingDataAddress < startingAddress && endingDataAddress > startingAddress && endingDataAddress < endingAddress) {
                        copySize = (int)(endingDataAddress - startingAddress);
                        recordDataIdx = hexRecord.getDataLength() - copySize;
                    }
                    if (startingDataAddress >= startingAddress && endingDataAddress < endingAddress) {
                        copySize = hexRecord.getDataLength();
                    }
                    if (startingDataAddress >= startingAddress && endingDataAddress >= endingAddress) {
                        copySize = (int)(endingAddress - startingDataAddress);
                    }
                    if (copySize <= 0) continue block7;
                    if (copySize > range) {
                        copySize = range;
                    }
                    byte[] recordData = hexRecord.getData();
                    System.arraycopy(recordData, recordDataIdx, data, dataIdx, copySize);
                    range -= copySize;
                    dataIdx += copySize;
                    continue block7;
                }
                case EXTENDED_SEG_ADDR: {
                    bufferReader.close();
                    inputReader.close();
                    LOGGER.log(Level.SEVERE, "0x02 Extended Sement Address Not Supported Record Type in intex_hex");
                    LOGGER.log(Level.SEVERE, "Throwing Exception!");
                    throw new HexException("Extended Segmented Address Records are not supported");
                }
                case START_SEGMENT_ADDR: {
                    LOGGER.log(Level.WARNING, "0x03 Start Segment Address is not a supported Record Type in intex_hex");
                    LOGGER.log(Level.WARNING, "Skipping line in Hex file; and continuing Parsing.");
                    continue block7;
                }
                case EXTENDED_LINEAR_ADDR: {
                    extendedAddress = Helper.getShort(hexRecord.getData(), 0, false);
                    extendedAddress &= 0xFFFFL;
                    extendedAddress <<= 16;
                    continue block7;
                }
                case START_LINEAR_ADDR: {
                    LOGGER.log(Level.WARNING, "0x05 Start Segment Address is not a supported Record Type in intex_hex");
                    LOGGER.log(Level.WARNING, "Skipping line in Hex file; and continuing Parsing.");
                    continue block7;
                }
            }
            throw new HexException("Bad intel_hex record type response");
        }
        return data;
    }

    public static byte[] getData(File hexFile, long startingAddress, int range) throws IOException, HexException {
        FileInputStream fileInputStream = new FileInputStream(hexFile);
        byte[] data = HexFile.getData(fileInputStream, startingAddress, range);
        fileInputStream.close();
        return data;
    }
}

