/*
 * Decompiled with CFR 0.152.
 */
package i2cReadWriteStopXferFunctions;

import com.microchip.scf.CommunicationsInterface;
import com.microchip.scf.exceptions.GenericException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import usbReadTransactionDataStructure.ReadTransactionResult;

public class I2CWritePacketTransaction {
    CommunicationsInterface communicationClass;
    private static final Logger LOGGER = Logger.getLogger(I2CWritePacketTransaction.class.getName());

    public I2CWritePacketTransaction(CommunicationsInterface communicationClass) {
        this.communicationClass = communicationClass;
    }

    public ReadTransactionResult WriteI2cPacket(byte[] usbPacketWrite, int timeoutMS) throws GenericException {
        int usbByteCount = 0;
        byte[] usbPacketRead = new byte[64];
        ReadTransactionResult readDataObj = new ReadTransactionResult();
        if (this.communicationClass == null) {
            LOGGER.log(Level.SEVERE, "Communication Class Not Initialized. Transaction cannot be completed");
            throw new GenericException("Communication Class Not Initialized. Transaction cannot be completed");
        }
        try {
            this.communicationClass.getOutputStream().write(usbPacketWrite);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "USB Packet Not Verified. Number of Read Bytes do not match with the expected value. " + ex.toString(), ex);
            throw new GenericException("USB Packet Not Verified. Number of Read Bytes do not match with the expected value");
        }
        for (int i = 0; i < usbPacketRead.length; ++i) {
            usbPacketRead[i] = 0;
        }
        try {
            usbByteCount = this.communicationClass.getInputStream().read(usbPacketRead);
            if (usbByteCount == 0) {
                LOGGER.log(Level.SEVERE, "USB Packet Not Verified. Device Disconnected");
                throw new GenericException("USB Packet Not Verified. Device Disconnected");
            }
            if (usbByteCount != 64) {
                LOGGER.log(Level.SEVERE, "USB Packet Not Verified. Number of Read Bytes do not match with the expected value");
                throw new GenericException("USB Packet Not Verified. Number of Read Bytes do not match with the expected value");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "USB Packet Not Verified. Number of Read Bytes do not match with the expected value");
            throw new GenericException("USB Packet Not Verified. Number of Read Bytes do not match with the expected value");
        }
        readDataObj.setParametersUSB(usbByteCount, usbPacketRead);
        return readDataObj;
    }
}

