/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import com.microchip.mcu8.commandcore.ACommandBase;
import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderModel.CommandModelWrite;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import protocol.nextchunkgetter.DataChunk;
import protocol.nextchunkgetter.IGetNextChunk;

public abstract class ACommandBaseExtendedWithDataPayloadAVR
extends ACommandBase {
    protected CommandModelWrite model;
    IGetNextChunk addressIterator;
    State state = State.INIT;
    static final Logger LOGGER = Logger.getLogger(ACommandBaseExtendedWithDataPayloadAVR.class.getName());

    public void setCommandModel(CommandModelWrite model) {
        this.model = model;
    }

    protected abstract void setEraseChunckIterator();

    @Override
    public int process() throws TransactionFailureException {
        int lengthReceived = 0;
        this.setEraseChunckIterator();
        this.setPacketProcessorToUse();
        while (this.retryCount != 0) {
            try {
                switch (this.state) {
                    case INIT: {
                        DataChunk chunk = this.addressIterator.getData();
                        this.model.address = chunk.address;
                        this.model.length = chunk.length;
                        this.model.dataPayload = chunk.data;
                        LOGGER.log(Level.FINE, String.format("Chunk Address: " + chunk.address + ", Chunk Length: " + chunk.length + ", Chunk Data: " + Arrays.toString(chunk.data) + ", Chunk No Data: " + chunk.noData, new Object[0]));
                        this.state = State.WRITE;
                        break;
                    }
                    case WRITE: {
                        StringBuilder sb;
                        this.commandSpecificPacketProcessor.packPacket(this.model, this.timeOut);
                        LOGGER.log(Level.FINE, "WRITE");
                        if (LOGGER.isLoggable(Level.FINER)) {
                            sb = new StringBuilder();
                            for (byte b : this.model.data) {
                                sb.append(String.format("%02X", b));
                            }
                            LOGGER.log(Level.FINER, sb.toString());
                        }
                        LOGGER.log(Level.FINE, "WRITE_DONE");
                        this.bootloaderOutputStream.write(this.model.data);
                        this.state = State.READ;
                        LOGGER.log(Level.FINE, "WRITE");
                        if (LOGGER.isLoggable(Level.FINER)) {
                            sb = new StringBuilder();
                            for (byte b : this.model.data) {
                                sb.append(String.format("%02X", b));
                            }
                            LOGGER.log(Level.FINER, sb.toString());
                        }
                        LOGGER.log(Level.FINE, "WRITE_DONE");
                        this.modelBootloader.setConsoleText(new String(this.model.dataRead));
                        break;
                    }
                    case READ: {
                        StringBuilder sb;
                        lengthReceived = this.bootloaderInputStream.read(this.model.dataRead);
                        this.state = State.VALIDATE;
                        LOGGER.log(Level.FINE, "READ");
                        if (LOGGER.isLoggable(Level.FINER)) {
                            sb = new StringBuilder();
                            for (byte b : this.model.dataRead) {
                                sb.append(String.format("%02X", b));
                            }
                            LOGGER.log(Level.FINER, sb.toString());
                        }
                        LOGGER.log(Level.FINE, "READ_DONE, lengthReceived: {0}", lengthReceived);
                        break;
                    }
                    case VALIDATE: {
                        this.processReadDataAVR.unpackPacket(lengthReceived, this.model, this.timeOut);
                        this.validateLevel2();
                        this.model.dataRead = this.model.dataRead;
                        this.state = State.ITERATE;
                        LOGGER.log(Level.FINE, "VALIDATE_SUCCESS");
                        break;
                    }
                    case ITERATE: {
                        DataChunk chunck = this.addressIterator.getData();
                        if (chunck != null) {
                            this.model.address = chunck.address;
                            this.model.length = chunck.length;
                            this.model.dataPayload = chunck.data;
                            LOGGER.log(Level.FINE, String.format("Chunk Address: " + chunck.address + ", Chunk Length: " + chunck.length + ", Chunk Data: " + Arrays.toString(chunck.data) + ", Chunk No Data: " + chunck.noData, new Object[0]));
                            this.state = State.WRITE;
                            break;
                        }
                        LOGGER.log(Level.FINE, "VALIDATE_SUCCESS");
                        return 0;
                    }
                }
            }
            catch (ValidationException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.whatException, ex);
                throw new TransactionFailureException("Transaction Failed." + ex.whatException);
            }
            catch (IOException ex) {
                --this.retryCount;
                if (this.retryCount != 0) continue;
                LOGGER.log(Level.SEVERE, "Transaction Failed." + ex.toString(), ex);
                throw new TransactionFailureException("Transaction Failed." + ex);
            }
        }
        return 0;
    }

    protected static enum State {
        INIT,
        READ,
        WRITE,
        VALIDATE,
        ITERATE;

    }
}

