/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController;

import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedNoDataPayloadAVR;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import packetprocessor.AVR_PacketProcessorNoDataPayload;
import readFileModel.MemoryModel;

public class CommandResetDeviceUART_AVR
extends ACommandBaseExtendedNoDataPayloadAVR {
    private static final int RESET_SUCCESS = 1;
    private static final int CMD_LENGTH = 11;
    private static final int READ_CMD_LENGTH = 10;
    private static final int SYNCH_BYTE_POS = 0;
    private static final int SYNCH_CHARACTER = 85;
    private static final int CMD_BYTE_POS = 1;
    private static final int RESET_CMD = 9;
    private static final int STATUS_BYTE_POS = 10;
    private static final Logger LOGGER = Logger.getLogger(CommandResetDeviceUART_AVR.class.getName());

    public CommandResetDeviceUART_AVR(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataAVR();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)9;
        this.model.length = 0L;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 11;
        this.model.readLengthExpected = 11;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "No Synch Byte before Response");
            throw new ValidationException("Malformed: No Synch Byte");
        }
        if (this.model.dataRead[1] != 9) {
            LOGGER.log(Level.SEVERE, "Bootloader Reset INCORRECT");
            throw new ValidationException("Malformed: Format not correct");
        }
        if (this.model.dataRead[10] != 1) {
            LOGGER.log(Level.SEVERE, "Reset Failed.");
            throw new ValidationException("Reset Failed.");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new AVR_PacketProcessorNoDataPayload();
    }
}

