/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController.avr;

import exceptionclasses.TransactionFailureException;
import exceptionclasses.ValidationException;
import i2cBootloaderController.ACommandBaseExtendedNoDataPayloadAVR;
import i2cBootloaderModel.CommandModelWrite;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import packetprocessor.AVR_MCU8_PacketProcessorWithDataPayloadUART;
import readFileModel.MemoryModel;

public class CommandReadVersionUART_AVR
extends ACommandBaseExtendedNoDataPayloadAVR {
    private final int READ_VER_CMD_SIZE = 24;
    private static final int CMD_LENGTH = 11;
    private static final int SYNCH_BYTE_POS = 0;
    private static final int SYNCH_CHARACTER = 85;
    private static final int CMD_BYTE_POS = 1;
    private static final int READ_VERSION_CMD = 0;
    private static final int PAGE_SIZE_BYTE_L = 20;
    private static final int PAGE_SIZE_BYTE_H = 21;
    private static final Logger LOGGER = Logger.getLogger(CommandReadVersionUART_AVR.class.getName());

    public CommandReadVersionUART_AVR(InputStream commsInputStream, OutputStream commsOutputStream, MemoryModel deviceMemoryModel) {
        this.bootloaderInputStream = commsInputStream;
        this.bootloaderOutputStream = commsOutputStream;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadDataAVR();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = 0;
        this.model.length = 0L;
        this.model.address = 0L;
        this.model.dataPayload = null;
        this.model.writeLength = 11;
        this.model.readLengthExpected = this.model.writeLength - 1 + 24;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int process() throws TransactionFailureException {
        super.process();
        this.modelBootloader.setVersion(new String(this.model.dataRead, Charset.forName("ISO-8859-1")));
        return 0;
    }

    @Override
    public int validateLevel2() throws ValidationException {
        int modelIndex = 0;
        if (this.model.dataRead.length != this.model.readLengthExpected) {
            LOGGER.log(Level.SEVERE, "Bootloader Version Response should be {0} bytes", this.model.readLengthExpected);
            throw new ValidationException("Bootloader Version Response wrong size");
        }
        if (this.model.dataRead[0] != 85) {
            LOGGER.log(Level.SEVERE, "No Synch Byte before Response");
            throw new ValidationException("Malformed: No Synch Byte");
        }
        for (modelIndex = 1; modelIndex < 11; ++modelIndex) {
            if (this.model.dataRead[modelIndex] == 0) continue;
            LOGGER.log(Level.SEVERE, "Bootloader Version Command Echo BAD");
            throw new ValidationException("Command Echo BAD");
        }
        if (this.model.dataRead[20] == 0 && this.model.dataRead[21] == 0) {
            LOGGER.log(Level.SEVERE, "Bootloader Version Command indicated No Page Size; Response must be MalFormed");
            throw new ValidationException("Bootloader Version format not correct");
        }
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    @Override
    protected void setPacketProcessorToUse() {
        this.commandSpecificPacketProcessor = new AVR_MCU8_PacketProcessorWithDataPayloadUART();
    }
}

