/*
 * Decompiled with CFR 0.152.
 */
package i2cBootloaderController.mcu8;

import com.microchip.scf.softwarelibraryinterfaces.i2c.I2CSoftwareLibraryCommunicationsInterface;
import exceptionclasses.ValidationException;
import i2cBootloaderController.mcu8.ACommandBaseI2CExtendedNoDataPayload;
import i2cBootloaderModel.CommandModelWrite;
import java.util.logging.Level;
import readFileModel.MemoryModel;

public class CommandChecksum_AVR
extends ACommandBaseI2CExtendedNoDataPayload {
    private static final byte CRC_CKSUM_CMD = 8;
    private static final int CMD_BYTE_POS = 0;
    private static final int CMD_INVALID = 255;
    private static final int CMD_UNSUPPORTED = 254;
    private static final int CMD_OUT_OF_RANGE = 253;
    private static final int CRC_OK = 2;
    private static final int CRC_BUSY = 1;
    private static final int CMD_LENGTH = 9;
    private static final int STATUS_BYTE_POS = 9;

    public CommandChecksum_AVR(I2CSoftwareLibraryCommunicationsInterface commsInterface, MemoryModel deviceMemoryModel) {
        this.i2cInterface = commsInterface;
        this.deviceMemoryModel = deviceMemoryModel;
        this.setProcessReadData();
        this.setCommandModel(new CommandModelWrite());
        this.model.command = (byte)8;
        this.model.length = deviceMemoryModel.byteAlignedProgramMemorySize - deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.address = deviceMemoryModel.byteAlignedBootloaderOffset;
        this.model.dataPayload = null;
        this.model.writeLength = 9;
        this.model.readLengthExpected = this.model.writeLength + 1;
        this.model.allocateReadWriteBufferMemory();
    }

    @Override
    public int validateLevel2() throws ValidationException {
        if (this.model.dataRead[0] != 8) {
            LOGGER.log(Level.SEVERE, "Bootloader CRC/CheckSum Command INCORRECT");
            throw new ValidationException("Malformed: Format not correct");
        }
        this.handleCrc(this.model.dataRead[9]);
        if (this.model.errorStatus) {
            this.model.errorStatus = false;
            return -1;
        }
        return 0;
    }

    private void handleCrc(int status) throws ValidationException {
        if (status != 2) {
            switch (status) {
                case 1: {
                    this.logError("CRC returned BUSY.");
                    break;
                }
                case -1: {
                    this.logResponseIssue("CRC Command Invalid.");
                    break;
                }
                case -3: {
                    this.logResponseIssue("CRC Command Out of Range.");
                    break;
                }
                case -2: {
                    this.logResponseIssue("CRC Command Invalid.");
                    break;
                }
                default: {
                    this.logError("CRC returned FAILURE.");
                    throw new ValidationException("CRC returned FAILURE.");
                }
            }
        }
    }

    private void logResponseIssue(String message) {
        this.logError("CRC Command Response had issue.");
        this.logError(message);
    }

    private void logError(String message) {
        LOGGER.log(Level.SEVERE, message);
    }
}

