/*
 * Decompiled with CFR 0.152.
 */
package readFileController;

import com.microchip.intel_hex.HexAddressRange;
import com.microchip.intel_hex.HexAddressRangeList;
import com.microchip.intel_hex.HexException;
import com.microchip.intel_hex.HexFile;
import i2cBootloaderModel.DeviceArchitecture;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import readFileController.IFileIO;
import readFileModel.MemoryModel;

public class HexFileIO
implements IFileIO {
    private FileAddressList fileAddressRange;
    private MemoryModel deviceMemoryModel;
    private DeviceArchitecture whichFamily;
    private static final Logger LOGGER = Logger.getLogger(HexFileIO.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File fopen(String fileName) {
        File fp = new File(fileName);
        try {
            this.fileAddressRange = new FileAddressList(HexAddressRangeList.getList((File)fp), fp);
            return fp;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IO Exception trigerred. No File Found" + ex.toString(), ex);
            return null;
        }
        catch (HexException ex) {
            LOGGER.log(Level.SEVERE, "HEX Exception trigerred. Not a HEX File" + ex.toString(), ex);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void fread(File fp) {
        block26: {
            memoryType = MemoryRecordTypes.PROGRAM_MEMORY;
            if (fp.getName().compareTo(this.fileAddressRange.fp.getName()) != 0) break block26;
            block20: for (i = 0; i < this.fileAddressRange.fileAddressRange.length; ++i) {
                tempBuffer = new byte[(int)this.fileAddressRange.fileAddressRange[i].getRange()];
                try {
                    tempBuffer = HexFile.getData((File)fp, (long)((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress()), (int)((int)this.fileAddressRange.fileAddressRange[i].getRange()));
                }
                catch (IOException ex) {
                    HexFileIO.LOGGER.log(Level.FINE, "IO Exception trigerred !!" + ex.toString(), ex);
                }
                catch (HexException ex) {
                    HexFileIO.LOGGER.log(Level.FINE, "HEX Exception trigerred !!" + ex.toString(), ex);
                }
                addressRange = "UnSupported";
                addressStart = Long.toHexString(this.fileAddressRange.fileAddressRange[i].getStartingAddress());
                addressLength = String.valueOf(this.fileAddressRange.fileAddressRange[i].getRange());
                block1 : switch (1.$SwitchMap$readFileController$HexFileIO$MemoryRecordTypes[memoryType.ordinal()]) {
                    case 1: {
                        if (this.deviceMemoryModel.byteAlignedProgramMemory == null) ** GOTO lbl29
                        if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() >= this.deviceMemoryModel.byteAlignedProgramMemorySize) ** GOTO lbl30
                        addressRange = "Program Memory";
                        for (j = 0; j < tempBuffer.length; ++j) {
                            if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j < this.deviceMemoryModel.byteAlignedProgramMemorySize) ** GOTO lbl26
                            HexFileIO.LOGGER.log(Level.FINE, "Declared Program Memory Size is Incorrect!!");
                            this.deviceMemoryModel.byteAlignedProgramMemory = null;
                            ** GOTO lbl30
lbl26:
                            // 1 sources

                            this.deviceMemoryModel.byteAlignedProgramMemory[(int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j] = tempBuffer[j];
                        }
                        ** GOTO lbl30
lbl29:
                        // 1 sources

                        HexFileIO.LOGGER.log(Level.FINE, "ByteAlignedProgramMemory Not Null");
                    }
lbl30:
                    // 5 sources

                    case 2: {
                        if (this.deviceMemoryModel.byteAlignedConfigurationWords == null) ** GOTO lbl42
                        if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() < this.deviceMemoryModel.byteAlignedConfigurationWordsOffset || (int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() >= this.deviceMemoryModel.byteAlignedConfigurationWordsOffset + this.deviceMemoryModel.byteAlignedConfigurationWordsSize) ** GOTO lbl43
                        addressRange = "Config Words";
                        for (j = 0; j < tempBuffer.length; ++j) {
                            if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j - this.deviceMemoryModel.byteAlignedConfigurationWordsOffset < this.deviceMemoryModel.byteAlignedConfigurationWordsSize) ** GOTO lbl39
                            HexFileIO.LOGGER.log(Level.FINE, "Declared CONFIG WORD Size is Incorrect!!");
                            this.deviceMemoryModel.byteAlignedConfigurationWords = null;
                            ** GOTO lbl43
lbl39:
                            // 1 sources

                            this.deviceMemoryModel.byteAlignedConfigurationWords[(int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j - this.deviceMemoryModel.byteAlignedConfigurationWordsOffset] = tempBuffer[j];
                        }
                        ** GOTO lbl43
lbl42:
                        // 1 sources

                        HexFileIO.LOGGER.log(Level.FINE, "byteAlignedConfigurationWords Not Null");
                    }
lbl43:
                    // 5 sources

                    case 3: {
                        if (this.deviceMemoryModel.byteAlignedEeprom != null) {
                            if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() < this.deviceMemoryModel.byteAlignedEepromMemoryOffset || (int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() >= this.deviceMemoryModel.byteAlignedEepromMemoryOffset + this.deviceMemoryModel.byteAlignedEepromSize) break;
                            addressRange = "EEPROM Memory";
                            for (j = 0; j < tempBuffer.length; ++j) {
                                if ((int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j - this.deviceMemoryModel.byteAlignedEepromMemoryOffset >= this.deviceMemoryModel.byteAlignedEepromSize) {
                                    HexFileIO.LOGGER.log(Level.FINE, "Declared EEPROM Size is Incorrect!!");
                                    this.deviceMemoryModel.byteAlignedEeprom = null;
                                    break block1;
                                }
                                this.deviceMemoryModel.byteAlignedEeprom[(int)this.fileAddressRange.fileAddressRange[i].getStartingAddress() + j - this.deviceMemoryModel.byteAlignedEepromMemoryOffset] = tempBuffer[j];
                            }
                            break;
                        }
                        HexFileIO.LOGGER.log(Level.FINE, "byteAlignedEeprom Not Null");
                    }
                }
                var8_8 = addressRange;
                var9_14 = -1;
                switch (var8_8.hashCode()) {
                    case -574494219: {
                        if (!var8_8.equals("UnSupported")) break;
                        var9_14 = 0;
                        break;
                    }
                    case 1629758045: {
                        if (!var8_8.equals("Program Memory")) break;
                        var9_14 = 1;
                        break;
                    }
                    case -1122952117: {
                        if (!var8_8.equals("Config Words")) break;
                        var9_14 = 2;
                        break;
                    }
                    case 1159584033: {
                        if (!var8_8.equals("EEPROm Memory")) break;
                        var9_14 = 3;
                    }
                }
                switch (var9_14) {
                    case 0: {
                        HexFileIO.LOGGER.log(Level.FINE, String.format("Hex has " + addressLength + " UnSupported Data @" + addressStart, new Object[0]));
                        continue block20;
                    }
                    case 1: {
                        HexFileIO.LOGGER.log(Level.FINE, String.format("Writing " + addressLength + " Program Memory Starting@" + addressStart, new Object[0]));
                        continue block20;
                    }
                    case 2: {
                        HexFileIO.LOGGER.log(Level.FINE, String.format("Writing " + addressLength + " Config Words Starting@" + addressStart, new Object[0]));
                        continue block20;
                    }
                    case 3: {
                        HexFileIO.LOGGER.log(Level.FINE, String.format("Writing " + addressLength + " EEPROM Memory Starting@" + addressStart, new Object[0]));
                    }
                }
            }
        }
    }

    @Override
    public void setMemoryModel(Object whatModel) {
        this.deviceMemoryModel = (MemoryModel)whatModel;
    }

    @Override
    public void setDeviceArchitecture(DeviceArchitecture whichFamily) {
        this.whichFamily = whichFamily;
    }

    private class FileAddressList {
        public HexAddressRange[] fileAddressRange;
        public File fp;

        public FileAddressList(HexAddressRange[] fileAddressRange, File fp) {
            this.fileAddressRange = fileAddressRange;
            this.fp = fp;
        }
    }

    private static enum MemoryRecordTypes {
        PROGRAM_MEMORY,
        CONFIGURATION_WORDS,
        EEPROM_MEMORY;

    }
}

