/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;

class HeadlessScreen
implements NativeScreen {
    protected int depth;
    protected int width;
    protected int height;
    protected Framebuffer fb;

    HeadlessScreen() {
        this(1280, 800, 32);
    }

    protected HeadlessScreen(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        String string = AccessController.doPrivileged(() -> System.getProperty("headless.geometry"));
        if (string != null && string.indexOf(120) > 0) {
            try {
                int n4 = string.indexOf("x");
                this.width = Integer.parseInt(string.substring(0, n4));
                int n5 = string.indexOf("-", n4 + 1);
                if (n5 > 0) {
                    this.depth = Integer.parseInt(string.substring(n5 + 1));
                } else {
                    n5 = string.length();
                }
                this.height = Integer.parseInt(string.substring(n4 + 1, n5));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Cannot parse geometry string: '" + string + "'");
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.width * this.height * (this.depth >>> 3));
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fb = new Framebuffer(byteBuffer, this.width, this.height, this.depth, true);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getNativeFormat() {
        return 1;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public long getNativeHandle() {
        return 1L;
    }

    @Override
    public int getDPI() {
        return 96;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void uploadPixels(Buffer buffer, int n, int n2, int n3, int n4, float f) {
        this.fb.composePixels(buffer, n, n2, n3, n4, f);
    }

    @Override
    public void swapBuffers() {
        this.fb.reset();
    }

    @Override
    public ByteBuffer getScreenCapture() {
        return this.fb.getBuffer();
    }
}

