/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Timer;
import org.eclipse.swt.widgets.Display;

final class SWTTimer
extends Timer
implements Runnable {
    Runnable timerRunnable;
    int period = 16;
    static final boolean THREAD_TIMER = System.getProperty("glass.swt.threadtimer") != null;

    protected SWTTimer(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected long _start(Runnable runnable) {
        return 1L;
    }

    @Override
    protected long _start(final Runnable runnable, final int n) {
        this.period = n;
        if (THREAD_TIMER) {
            this.timerRunnable = runnable;
            new Thread(this).start();
            return 1L;
        }
        final Display display = Display.getDefault();
        this.timerRunnable = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                display.timerExec(n, (Runnable)this);
            }
        };
        display.asyncExec(() -> {
            display.timerExec(n, this.timerRunnable);
            display.addListener(12, event -> {
                if (this.timerRunnable == null) {
                    return;
                }
                display.timerExec(-1, this.timerRunnable);
                this.timerRunnable = null;
            });
        });
        return 1L;
    }

    @Override
    protected void _stop(long l) {
        if (this.timerRunnable == null) {
            return;
        }
        if (THREAD_TIMER) {
            this.timerRunnable = null;
            return;
        }
        Display display = Display.getDefault();
        display.asyncExec(() -> {
            if (this.timerRunnable == null) {
                return;
            }
            display.timerExec(-1, this.timerRunnable);
            this.timerRunnable = null;
        });
    }

    @Override
    protected void _pause(long l) {
    }

    @Override
    protected void _resume(long l) {
    }

    @Override
    public void run() {
        while (this.timerRunnable != null) {
            long l = System.currentTimeMillis();
            this.timerRunnable.run();
            long l2 = (long)this.period - (System.currentTimeMillis() - l);
            if (l2 <= 0L) continue;
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

