/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.helper;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Helper {
    public static short getShort(byte[] buffer, int offset) {
        int value = buffer[offset + 1] & 0xFF;
        value <<= 8;
        return (short)(value |= buffer[offset] & 0xFF);
    }

    public static short getShort(byte[] buffer, int offset, boolean littleEndian) {
        byte[] shortBuffer = new byte[2];
        if (littleEndian) {
            shortBuffer[0] = buffer[0];
            shortBuffer[1] = buffer[1];
        } else {
            shortBuffer[0] = buffer[1];
            shortBuffer[1] = buffer[0];
        }
        return Helper.getShort(shortBuffer, 0);
    }

    public static int getInt(byte[] buffer, int offset) {
        int value = Helper.getShort(buffer, offset + 2) & 0xFFFF;
        value <<= 16;
        return value |= Helper.getShort(buffer, offset) & 0xFFFF;
    }

    public static void putShort(short value, byte[] buffer, int offset) {
        buffer[offset] = (byte)(value & 0xFF);
        buffer[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static void putInt(int value, byte[] buffer, int offset) {
        buffer[offset] = (byte)(value & 0xFF);
        buffer[offset + 1] = (byte)(value >> 8 & 0xFF);
        buffer[offset + 2] = (byte)(value >> 16 & 0xFF);
        buffer[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    public static String createSize(int size) {
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(',');
        df.setDecimalFormatSymbols(dfs);
        return df.format(size);
    }

    public static byte asciiHexToByte(char[] ascii, int offset) {
        int data = (Helper.asciiHexToNibble(ascii[offset]) & 0xF) << 4;
        return (byte)(data += Helper.asciiHexToNibble(ascii[offset + 1]) & 0xF);
    }

    public static short asciiHexToShort(char[] ascii, int offset) {
        int data = (Helper.asciiHexToByte(ascii, offset) & 0xFF) << 8;
        return (short)(data += Helper.asciiHexToByte(ascii, offset + 2) & 0xFF);
    }

    public static byte asciiHexToNibble(char ascii) {
        if (ascii >= '0' && ascii <= '9') {
            return (byte)(ascii & 0xF);
        }
        if (ascii >= 'a' && ascii <= 'f') {
            return (byte)(10 + (ascii - 97));
        }
        if (ascii >= 'A' && ascii <= 'F') {
            return (byte)(10 + (ascii - 97));
        }
        return 0;
    }
}

